////////////////////////////////////////////////////////////////////////////
//
//  CryEngine Source File.
//  Copyright (C), Crytek, 1999-2009.
// -------------------------------------------------------------------------
//  File name:   MapList.cpp
//  Version:     v1.00
//  Created:     05/10/2009 by Steve Barnett.
//  Description: This the implementation of the CMapList
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"

#include "MapList.h"

#include <vector>

void CMapList::AddMap( const std::string& sMapName )
{
	if( !sMapName.empty() )
	{
		m_mapNames.push_back( sMapName );
	}
}

size_t CMapList::GetNumMaps() const
{
	return m_mapNames.size();
}

void CMapList::SetCurrentMap( const size_t map )
{
	m_currentMap = map;
	if ( m_currentMap >= GetNumMaps() )
	{
		m_currentMap = 0;
	}
}

const char* CMapList::GetCurrentMap()
{
	return GetMap(m_currentMap);
}

const char* CMapList::GetMap( const size_t map )
{
	if(map >= 0 && map < GetNumMaps())
	{
		return m_mapNames[map].c_str();
	}
	return NULL;
}	

bool CMapList::IsLastMap()
{
	if ( GetNumMaps() == 0 ) return true;

	size_t lastMap = GetNumMaps() - 1;
	return m_currentMap >= lastMap;
}

void CMapList::NextMap()
{
	++m_currentMap;
	if ( m_currentMap >= GetNumMaps() )
	{
		m_currentMap = 0;
	}
}

void CMapList::Clear()
{
	m_currentMap = 0;
	m_mapNames.clear();
}
