////////////////////////////////////////////////////////////////////////////
//
//  CryEngine Source File.
//  Copyright (C), Crytek, 1999-2009.
// -------------------------------------------------------------------------
//  File name:   MapList.h
//  Version:     v1.00
//  Created:     05/10/2009 by Steve Barnett.
//  Description: This the declaration of the CMapList
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////

#ifndef __MAPLIST_H__
#define __MAPLIST_H__

#include <string>
#include <vector>

class CMapList
{
public:
	CMapList() : m_currentMap( 0 ) {}

	void AddMap( const std::string& sMapName );
	size_t GetNumMaps() const;
	void SetCurrentMap( const size_t map );
	const char* GetCurrentMap();
	const char* GetMap( const size_t map );
	bool IsLastMap();
	void NextMap();
	void Clear();

	const std::vector<std::string>& GetMapNames() const { return m_mapNames; }

protected:
	std::vector<std::string> m_mapNames;
	size_t m_currentMap;
};

#endif	// __MAPLIST_H__
