////////////////////////////////////////////////////////////////////////////
//
//  CryEngine Source File.
//  Copyright (C), Crytek, 1999-2009.
// -------------------------------------------------------------------------
//  File name:   Confluence.h
//  Version:     v1.00
//  Created:     01/11/2009 by Steve Barnett.
//  Description: DLL wrapper for accessing C-Sharp SOAP stubs from native
//                C++
//								
// -------------------------------------------------------------------------
//  History:
//
// -------------------------------------------------------------------------
//	Notes:
//	This links to ConfluenceAPI whose main source file
//	ConfluenceSoapServiceService.cs is generated automatically by the .NET
//	WSDL tool. This is currently automatically performed by the prebuild
//	step "C:\Program Files\Microsoft.NET\SDK\v2.0 64bit\bin\wsdl.exe" \
//	/language:CS http://confluence/rpc/soap-axis/confluenceservice-v1?wsdl
//	in the ConfluenceAPI vcproj but the path may need to be updated if the
//	SDK is installed in a non-standard location or moves in the future.
//
////////////////////////////////////////////////////////////////////////////

#include <assert.h>
#include <string.h>
#include <msclr/marshal.h>
#include "Confluence.h"

void MSToString( char*& pString, System::String^ sManaged )
{
	assert( pString == 0 );
	const int iLen = sManaged->Length;
	pString = new char[iLen + 1];
	msclr::interop::marshal_context^ context = gcnew msclr::interop::marshal_context();
	const char* pStr = context->marshal_as<const char*>( sManaged );
	strncpy_s( pString, iLen + 1, pStr, iLen );
	pString[iLen] = '\0';
	delete context;
}

void ManagedPageToPage( RemotePage^ managedPage, ConfluencePage& page )
{
	// AbstractRemotePageSummary
	page.idField = managedPage->id;
	page.permissionsField = managedPage->permissions;
	MSToString( page.spaceField, managedPage->space );
	MSToString( page.titleField, managedPage->title );
	MSToString( page.urlField, managedPage->url );

	// RemotePageSummary
	page.parentIdField = managedPage->parentId;

	// RemotePage
	MSToString( page.contentField, managedPage->content );
	MSToString( page.contentStatusField, managedPage->contentStatus );
	// createdField
	MSToString( page.creatorField, managedPage->creator );
	page.currentField = managedPage->current;
	page.homePageField = managedPage->homePage;
	// modifiedField
	MSToString( page.modifierField, managedPage->modifier  );
	page.versionField = managedPage->version;
}

void PageToManagedPage( ConfluencePage& page, RemotePage^ managedPage )
{
	// AbstractRemotePageSummary
	managedPage->id = page.idField;
	managedPage->permissions = page.permissionsField;
	managedPage->space = gcnew System::String( page.spaceField );
	managedPage->title = gcnew System::String( page.titleField );
	managedPage->url = gcnew System::String( page.urlField );

	// RemotePageSummary
	managedPage->parentId = page.parentIdField;

	// RemotePage
	managedPage->content = gcnew System::String( page.contentField );
	managedPage->contentStatus = gcnew System::String( page.contentStatusField );
	// created field
	managedPage->creator = gcnew System::String( page.creatorField );
	managedPage->current = page.currentField;
	managedPage->homePage = page.homePageField;
	// modified field
	managedPage->modifier = gcnew System::String( page.modifierField );
	managedPage->version = page.versionField;
}

bool Login( const char* const username, const char* const password, char* const pBuffer, const int iMaxLen )
{
	if ( !username || !password || !pBuffer ) return false;
	ConfluenceSoapServiceService service;
	System::String^ sUsername = gcnew System::String( username );
	System::String^ sPassword = gcnew System::String( password );

	System::String^ authToken = service.login( sUsername, sPassword );
	if ( authToken->Length == 0 ) return false;

	msclr::interop::marshal_context^ context = gcnew msclr::interop::marshal_context();
	const char* pStr = context->marshal_as<const char*>( authToken );
	strncpy_s( pBuffer, iMaxLen, pStr, authToken->Length );
	delete context;

	return true;
}

void Logout( const char* const authToken )
{
	if ( !authToken ) return;

	System::String^ sAuthToken = gcnew System::String( authToken );
	ConfluenceSoapServiceService service;
	service.logout( sAuthToken );
}

bool GetPage( const char* const authToken, const char* const space, const char* const page, ConfluencePage& remotePage )
{
	if ( !authToken || !space || !page ) return false;

	System::String^ sAuthToken = gcnew System::String( authToken );
	System::String^ sSpace = gcnew System::String( space );
	System::String^ sPage = gcnew System::String( page );

	ConfluenceSoapServiceService service;
	RemotePage^ managedPage = service.getPage( sAuthToken, sSpace, sPage );

	ManagedPageToPage( managedPage, remotePage );

	return true;
}

void FreePage( ConfluencePage* page )
{
	if ( !page ) return;

	delete[] page->spaceField;
	delete[] page->titleField;
	delete[] page->urlField;
	delete[] page->contentField;
	delete[] page->contentStatusField;
	delete[] page->creatorField;
	delete[] page->modifierField;
	page->spaceField = 0;
	page->titleField = 0;
	page->urlField = 0;
	page->contentField = 0;
	page->contentStatusField = 0;
	page->creatorField = 0;
	page->modifierField = 0;
}

void HackySleepToPreventConfluenceCorruption()
{
	// [AlexMcC|17/11/09] The confluence page keeps getting corrupted after attaching or removing
	// files (I'm not sure which), and it seems to be a timing issue. Let's slow things way down.
	// This adds 1 second per attachment upload, or 2 seconds per map.
	//
	// I'm so, so sorry.
	Sleep(500); 
}

bool AttachFile( const char* const authToken, const char* const filename, const char* const shortFilename, const char* const title, const char* const mimeType, const unsigned char* const pData, const unsigned int uDataSize, LONG64 pageId )
{
	if ( !authToken || !filename || !shortFilename || !title || !mimeType || !pData ) return false;

	ConfluenceSoapServiceService service;

	// Check if the attachment already exists and if so delete it
	System::String^ sAuthToken = gcnew System::String( authToken );
	System::String^ sShortFilename = gcnew System::String( shortFilename );
	if ( service.removeAttachment( sAuthToken, pageId, sShortFilename ) )
	{
		// Create the attachment structure and send it
		RemoteAttachment^ attachment = gcnew RemoteAttachment();
		attachment->id = 0;
		attachment->pageId = pageId;
		attachment->title = gcnew System::String( title );
		attachment->fileName = sShortFilename;
		attachment->fileSize = uDataSize;
		attachment->contentType = gcnew System::String( mimeType );
		attachment->comment = "";

		cli::array<unsigned char, 1>^ data = gcnew cli::array<unsigned char, 1>(uDataSize);
		for ( unsigned int i = 0; i < uDataSize; ++i )
		{
			data[i] = pData[i];
		}

		RemoteAttachment^ remoteAttachment = service.addAttachment( sAuthToken, pageId, attachment, data );
		if ( remoteAttachment == nullptr )
		{
			fprintf( stderr, "Error uploading attachment '%s' to page %i.\n", shortFilename, pageId );
			return false;
		}

		HackySleepToPreventConfluenceCorruption();

		printf( "[Confluence] Attached file '%s'.\n", shortFilename );
	}
	else
	{
		fprintf( stderr, "Error removing attachment '%s' from page %i.\n", shortFilename, pageId );
		return false;
	}

	// double check that we can get the attachment
	RemoteAttachment^ existing;
	if ( existing = service.getAttachment( sAuthToken, pageId, sShortFilename, 0 ) )
	{
		if ( existing->fileSize > 0 )
		{
			return true;
		}
		else
		{
			fprintf( stdout, "Uploaded attachment '%s', but couldn't get the attachment again!\n", shortFilename );
		}
	}
	else
	{
		fprintf( stdout, "Uploaded attachment '%s', but calling getAttachment again failed!\n", shortFilename );
	}

	return false;
}
