////////////////////////////////////////////////////////////////////////////
//
//  CryEngine Source File.
//  Copyright (C), Crytek, 1999-2009.
// -------------------------------------------------------------------------
//  File name:   ConfluenceStubs.h
//  Version:     v1.00
//  Created:     01/11/2009 by Steve Barnett.
//  Description: Stubs for runtime linking to ConfluenceWrapper.dll
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////

struct ConfluencePage
{
	// AbstractRemotePageSummary
	LONG64 idField;
	int permissionsField;
	char* spaceField;
	char* titleField;
	char* urlField;

	// RemotePageSummary
	LONG64 parentIdField;

	// RemotePage
	char* contentField;
	char* contentStatusField;
	SYSTEMTIME createdField;
	char* creatorField;
	bool currentField;
	bool homePageField;
	char* modifierField;
	SYSTEMTIME modifiedField;
	int versionField;
};

typedef bool (ConfLogin)( const char* const username, const char* const password, char* const authToken, const int iMaxLen );
typedef void (ConfLogout)( const char* const authToken );
typedef bool (ConfGetPage)( const char* const authToken, const char* const space, const char* const page, ConfluencePage& remotePage );
typedef void (ConfFreePage)( ConfluencePage* page );
typedef bool (ConfAttachFile)( const char* const authToken, const char* const filename, const char* const shortFilename, const char* const title, const char* const mimeType, const unsigned char* pData, const unsigned int uDataSize, LONG64 pageId );
	
struct ConfluenceStubs
{
	ConfLogin* pfnLogin;
	ConfLogout* pfnLogout;
	ConfGetPage* pfnGetPage;
	ConfFreePage* pfnFreePage;
	ConfAttachFile* pfnAttachFile;
};
