////////////////////////////////////////////////////////////////////////////
//
//  CryEngine Source File.
//  Copyright (C), Crytek, 1999-2009.
// -------------------------------------------------------------------------
//  File name:   ConsolePS3.h
//  Version:     v1.00
//  Created:     28/09/2009 by Steve Barnett.
//  Description: Class for communication the PS3
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////

#ifndef __CONSOLEPS3_H__
#define __CONSOLEPS3_H__

#include "IConsoleInterface.h"

#include <windows.h>
#include <vector>

#include "PS3tmapi.h"

class CConsolePS3 : public IConsoleInterface
{
public:
	CConsolePS3( const char* const pExePath, const char* const pArguments, const char* const pTarget, const char* const pPipeName, SLogger* const pLogger, bool verbose = false, bool outputTTY = true );
	~CConsolePS3( void );

	// Target connection
	virtual bool Connect( void );
	virtual void Shutdown( void );

	// Target communication
	virtual void UpdateComms( void );
	virtual bool CreatePipe( void );
	virtual void SendToPipe( const char* const );
	virtual const char* ReadFromPipe( char* const pBuf, const int len );
	virtual void ClosePipe( void );
	virtual bool WaitForConnected( void );
	virtual bool WaitForFinished( void );
	virtual const char* const GetMatchingResponse( const EResponseType eExpectedType );

	virtual bool GatherDumpFile( const char* const pMapName, const char* const pDumpFile, const char* const pOutputDir );

protected:
	typedef std::vector<const char*> TArguments;

	// Platform implementation
	virtual bool ResetImpl( const std::vector<std::string> &cmdLineParams, bool hardReset );

	// PS3 Specific
	int HandleEnumCallBack(HTARGET hTarget);
	bool FindFirstConnectedTarget(void);
	bool FindFirstAvailableTarget(void);
	bool GetTargetFromIP(const char* pszIPAddr, HTARGET &hTarget);
	bool SetFSDir(void);
	bool SetHomeDir(void);
	bool InitializeTTYStreams();
	void HandleProcessTTYCallback( HTARGET /*hTarget*/, UINT uiType, UINT uiStreamId, SNRESULT /*Result*/, UINT uiLength, BYTE *pData );
	void ClearMessagesBeforeExit(void);
	void FinalizeTTYStreams();
	bool DisconnectTTYEvents(void);
	void FreeTargetList();
	TArguments GetArguments( const std::vector<std::string> &cmdLineParams ) const;

	static void ProcessArgument( TArguments& list, const std::string& sArgument );

	static int EnumCallBack(HTARGET hTarget, void* pInstance);
	static void __stdcall ProcessTTYCallback(HTARGET hTarget, UINT uiType, UINT uiStreamId, SNRESULT result, UINT uiLength, BYTE *pData, void* pInstance );

	// Console output
	using IConsoleInterface::PrintError;
	virtual void PrintError( const char* const pError, SNRESULT res );

	// Members
	std::vector<SNPS3TargetInfo*>	m_Targets;
	TTYSTREAM	*m_pTTYStreams;
	u_int m_numTTYStreams;
	
	HTARGET	m_hTargetId;
	
	char* m_pSelfFilename;
	char* m_pHomeDirectory;
	
	std::vector<char*> m_TTYChannelNames;
	std::vector<UINT> m_TTYChannels;
	
	bool m_existingConnection;

	const DWORD m_pipeBufferSize;
	char m_pPipeBuffer[BUFFERSIZE];
	DWORD m_pipeReadChars;
	HANDLE m_hPipe;
};

#endif
