////////////////////////////////////////////////////////////////////////////
//
//  CryEngine Source File.
//  Copyright (C), Crytek, 1999-2009.
// -------------------------------------------------------------------------
//  File name:   ConsoleXBox.h
//  Version:     v1.00
//  Created:     19/10/2009 by Steve Barnett.
//  Description: Class for communication with the XBox360
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////

#ifndef __CONSOLEXBOX_H__
#define __CONSOLEXBOX_H__

#include "IConsoleInterface.h"

#include <windows.h>
#include <vector>
#include <queue>
#include <Xbdm.h>

class CConsoleXBox : public IConsoleInterface
{
public:
	CConsoleXBox( const char* const pExePath, const char* const pArguments, const char* const pTarget, const char* const pPipeName, SLogger* const pLogger, bool verbose = false, bool outputTTY = true );
	~CConsoleXBox( void );

	// Target connection
	virtual bool Connect( void );
	virtual void Shutdown( void );

	// Target communication
	virtual void UpdateComms( void );
	virtual bool CreatePipe( void );
	virtual void SendToPipe( const char* const pData );
	virtual const char* ReadFromPipe( char* const pBuf, const int len );
	virtual void ClosePipe( void );
	virtual bool WaitForConnected( void );
	virtual bool WaitForFinished( void );
	virtual const char* const GetMatchingResponse( const EResponseType eExpectedType );

	virtual bool GatherDumpFile( const char* const pMapName, const char* const pDumpFile, const char* const pOutputDir );

protected:
	// Debug Monitor has a maximum number of characters that it will send so I'm not using the BUFFERSIZE macro for some members
	static const int s_DMBUFFERSIZE = 256;

	// Response queue management
	void PopResponse( char* const pBuffer, int len );

	// XBox 360 implementation
	virtual bool ResetImpl( const std::vector<std::string> &cmdLineParams, bool hardReset );

	// Console output
	using IConsoleInterface::PrintError;
	virtual void PrintError( const char* const pError, HRESULT res );

	// Notification handler
	DWORD ProcessNotification( const CHAR* pNotification );
	static DWORD __stdcall NotificationHandler( const CHAR* pNotification );
	DWORD __stdcall ProcessDebugString( ULONG dwNotification, DWORD dwParam );
	static DWORD __stdcall DebugStringHandler( ULONG dwNotification, DWORD dwParam );

	// Members
	char* m_pXexDirectory;
	char* m_pRealTarget;
	HANDLE m_hResponseWaiting;
	HANDLE m_hResponseLock;
	typedef std::queue<std::string> ResponseQueue;
	ResponseQueue m_responseQueue;

	PDM_CONNECTION m_connection;
	PDMN_SESSION m_session;

	static CConsoleXBox* s_pInstance;
};

#endif
