////////////////////////////////////////////////////////////////////////////
//
//  CryEngine Source File.
//  Copyright (C), Crytek, 1999-2010.
// -------------------------------------------------------------------------
//  File name:   LoadTestJob.h
//  Version:     v1.00
//  Created:     26/01/2010 by Steve Barnett.
//  Description: LoadTest a single level from an SJob
////////////////////////////////////////////////////////////////////////////

#ifndef __LOADTESTJOB_H__
#define __LOADTESTJOB_H__

#include "LoadTestOptions.h"
#include "Common/Config.h"

//struct SJob;
class IConsoleInterface;

class CLoadTestJob
{
	SJob* const m_pJob;
	IConsoleInterface* m_pTarget;
	char m_pAutoBuffer[BUFFER_SIZE];
	char m_pManualBuffer[BUFFER_SIZE];
	
public:
	CLoadTestJob( SJob* pJob );
	~CLoadTestJob( void );

	bool Run( void );

	static bool RunJob( CLoadTestJob* pJob );
	
protected:
	SConfig& GetConfig( void );

	

	bool RunPostprocessTask( const char* const pOutFile, const char* const pExecutable );
};

#endif
