////////////////////////////////////////////////////////////////////////////
//
//  CryEngine Source File.
//  Copyright (C), Crytek, 1999-2010.
// -------------------------------------------------------------------------
//  File name:   TelnetServer.h
//  Version:     v1.00
//  Created:     12/03/2010 by Steve Barnett.
//  Description: Telnet server for remotely managing a LoadTest instance
////////////////////////////////////////////////////////////////////////////

#ifndef __TELNETSERVER_H__
#define __TELNETSERVER_H__

#include <winsock.h>

#include "LoadTestOptions.h"

#include "Common/Config.h"

class CTelnetServer
{
public:
	enum EProcessResponse
	{
		ePRValid = 0,
		ePRError,
		ePRDisconnect,
	};

	CTelnetServer( JobList* pJobs, SOCKET* pSock = NULL ) : m_pJobs( pJobs ), m_pSock( pSock ), m_isListener( pSock == NULL ), m_hExit( NULL ) {}
	virtual ~CTelnetServer( void );

	void StartListenerThread( unsigned int port );
	void StopListenerThread( void );

private:
	// Listener
	int ListenerThread_Impl( void );

	// Generic telnet server stuff
	void StartServerThread( void );
	int ServerThread_Impl( void );
	bool ProcessCommands( void );

	EProcessResponse ProcessData( const char* const pData, int& consumed );
	bool SendData( const char* pData );

	// Command processing
	EProcessResponse ProcessCommand( const char* const pCommand );

	// Specific command implementations
	void CancelAllJobs( void );
	void CancelCurrentJobs( void );
	void CancelJobByMapName( const char* const pMap );
	void SendStatusReport( void );
	void SendHelpMessage( void );

	static void __cdecl ServerThread( void* pInstVoid );
	static void __cdecl ListenerThread( void* pInstVoid );

	JobList* m_pJobs;
	SOCKET* m_pSock;
	bool m_isListener;
	unsigned int m_port;
	HANDLE m_hExit;
};

#endif
