// MemReplayDoc.h : interface of the CMemReplayDoc class
//


#pragma once

#include "ReplaySDK/ReplayDoc.h"

class CMemReplayView;
class MemHier;
class ContextTree;

class CMemReplayDoc : public CDocument
{
protected: // create from serialization only
	CMemReplayDoc();
	DECLARE_DYNCREATE(CMemReplayDoc)

// Attributes
public:
	SharedPtr<ReplayLogReader> GetReplayStream() const { return m_sdkDoc.IsValid() ? m_sdkDoc->GetReplayStream() : NULL; }
	SharedPtr<SymbolHelper> GetSymbolTable() const { return m_sdkDoc.IsValid() ? m_sdkDoc->GetSymbolTable() : NULL; }

	SharedPtr<ContextTree> GetAssetTree() const { return m_sdkDoc.IsValid() ? m_sdkDoc->GetAssetTree() : NULL; }
	SharedPtr<AllocSetLST> GetAllocSetLST() const { return m_sdkDoc.IsValid() ? m_sdkDoc->GetAllocSetLST() : NULL; }

	SharedPtr<FrameUsageTracker> GetFrameUsageTracker() { return m_sdkDoc.IsValid() ? m_sdkDoc->GetFrameUsageTracker() : NULL; }

	SharedPtr<MemoryMapReplay> GetMemMap() const { return m_sdkDoc.IsValid() ? m_sdkDoc->GetMemMap() : NULL; }
	SharedPtr<ReplayValidator> GetValidation() const { return m_sdkDoc.IsValid() ? m_sdkDoc->GetValidation() : NULL; }

	SharedPtr<ContextTree> GetCgfPhysicsTree() { return m_sdkDoc.IsValid() ? m_sdkDoc->GetCgfPhysicsTree() : NULL; }
	SharedPtr<ContextTree> GetTextureTree() { return m_sdkDoc.IsValid() ? m_sdkDoc->GetTextureTree() : NULL; }
	SharedPtr<ContextTree> GetRenderMeshTree() { return m_sdkDoc.IsValid() ? m_sdkDoc->GetRenderMeshTree() : NULL; }
	SharedPtr<ContextTree> GetTerrainTree() { return m_sdkDoc.IsValid() ? m_sdkDoc->GetTerrainTree() : NULL; }
	SharedPtr<ContextTree> GetAnimationTree() { return m_sdkDoc.IsValid() ? m_sdkDoc->GetAnimationTree() : NULL; }
	SharedPtr<ContextTree> GetNavTree() { return m_sdkDoc.IsValid() ? m_sdkDoc->GetNavTree() : NULL; }
	SharedPtr<ContextTree> GetEntityTree() { return m_sdkDoc.IsValid() ? m_sdkDoc->GetEntityTree() : NULL; }
	SharedPtr<ContextTree> GetSoundProjectTree() { return m_sdkDoc.IsValid() ? m_sdkDoc->GetSoundProjectTree() : NULL; }
	SharedPtr<ContextTree> GetOverviewTree() { return m_sdkDoc.IsValid() ? m_sdkDoc->GetOverviewTree() : NULL; }

	ICSVExporter* GetOverviewExporter() { return m_sdkDoc.IsValid() ? &m_sdkDoc->GetOverviewExporter() : NULL; }
	ICSVExporter* GetCgfPhysicsExporter() { return m_sdkDoc.IsValid() ? &m_sdkDoc->GetCgfPhysicsExporter() : NULL; }
	ICSVExporter* GetTextureExporter() { return m_sdkDoc.IsValid() ? &m_sdkDoc->GetTextureExporter() : NULL; }
	ICSVExporter* GetRenderMeshExporter() { return m_sdkDoc.IsValid() ? &m_sdkDoc->GetRenderMeshExporter() : NULL; }
	ICSVExporter* GetAnimationExporter() { return m_sdkDoc.IsValid() ? &m_sdkDoc->GetAnimationExporter() : NULL; }
	ICSVExporter* GetNavExporter() { return m_sdkDoc.IsValid() ? &m_sdkDoc->GetNavExporter() : NULL; }
	ICSVExporter* GetEntityExporter() { return m_sdkDoc.IsValid() ? &m_sdkDoc->GetEntityExporter() : NULL; }
	ICSVExporter* GetSoundProjectExporter() { return m_sdkDoc.IsValid() ? &m_sdkDoc->GetSoundProjectExporter() : NULL; }

	ContextTreePtr GetContextTreeByType( MemStatContextTypes::Type type ) { return m_sdkDoc.IsValid() ? m_sdkDoc->GetContextTree(type) : NULL; }
	ICSVExporter* GetExporterByType( MemStatContextTypes::Type type ) { return m_sdkDoc.IsValid() ? m_sdkDoc->GetExporterByType(type) : NULL; }

// Operations
public:

// Overrides
public:
	virtual BOOL OnNewDocument();
	virtual void OnFileSaveAs();
	virtual BOOL OnOpenDocument(LPCTSTR lpszPathName);
	virtual BOOL OnSaveDocument(LPCTSTR lpszPathName);
	virtual void Serialize(CArchive& ar);

// Implementation
public:
	virtual ~CMemReplayDoc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
	CMemReplayView* GetView();

// Generated message map functions
protected:
	DECLARE_MESSAGE_MAP()

private:
	SharedPtr<ReplayDoc> m_sdkDoc;
};
