#include "stdafx.h"
#include "ReplayCapture.h"

#if 0
ReplayCapture::ReplayCapture()
	: m_thread(NULL)
	, m_listener(NULL)
	, m_clientSock(INVALID_SOCKET)
{
}

bool ReplayCapture::BeginCapture(const char* filename, IReplayListener& listeners)
{
	if (m_thread)
		return false;

	m_filename = filename;
	m_listener = &listeners;

	m_thread = AfxBeginThread(ThreadProxy, this);
	if (!m_thread)
		return false;

	return true;
}

void ReplayCapture::EndCapture()
{
	if (m_clientSock != INVALID_SOCKET)
		closesocket(m_clientSock);
}

UINT __cdecl ReplayCapture::ThreadProxy(LPVOID param)
{
	return reinterpret_cast<ReplayCapture*>(param)->ThreadMain();
}

UINT ReplayCapture::ThreadMain()
{
	struct addrinfo hints = {0};

	hints.ai_family = AF_UNSPEC;
	hints.ai_socktype = SOCK_STREAM;
	hints.ai_flags = AI_PASSIVE;

	struct addrinfo* res;
	getaddrinfo(NULL, "3490", &hints, &res);

	SOCKET listenSock = socket(res->ai_family, res->ai_socktype, res->ai_protocol);
	bind(listenSock, res->ai_addr, res->ai_addrlen);

	freeaddrinfo(res);

	listen(listenSock, 5);

	struct sockaddr_in clientAddr;
	int clientAddrLen;
	m_clientSock = accept(listenSock, (struct sockaddr*) &clientAddr, &clientAddrLen);

	do
	{
		char buf[1024 * 1024];
		int res = recv(m_clientSock, buf, sizeof(buf), 0);

		if ((res == 0) || (res == SOCKET_ERROR))
		{
			break;
		}
	}
	while(true);

	closesocket(m_clientSock);
	shutdown(listenSock, SD_BOTH);
	closesocket(listenSock);

	return 0;
}

#endif
