////////////////////////////////////////////////////////////////////////////
//
//  CryEngine Source File.
//  Copyright (C), Crytek, 1999-2009.
// -------------------------------------------------------------------------
//  File name:   ReplayHandler.cpp
//  Version:     v1.00
//  Created:     07/10/2009 by Steve Barnett.
//  Description: This the declaration for CReplayHandler to deal with
//								accessing ReplaySDK in a generic way
// -------------------------------------------------------------------------
//  History:
//
//	07/10/2009: Load logs using ReplaySDK and generate summary spreadsheets
//
////////////////////////////////////////////////////////////////////////////

#ifndef __REPLAYHANDLER_H__
#define __REPLAYHANDLER_H__

#include "stdafx.h"

#include <Windows.h>
#include <malloc.h>
#include <assert.h>
#include <vector>
#include <set>
#include <string>
#include <algorithm>
#include <xutility>

#include "ReplaySDK/common.h"
#include "ReplaySDK/Utility.h"
#include "ReplaySDK/SharedPtr.h"
#include "ReplaySDK/Allocator.h"
#include "ReplaySDK/Serialise.h"
#include "ReplaySDK/SymbolTableBuilder.h"
#include "ReplaySDK/ReplayLogReader.h"
#include "ReplaySDK/ContextTree.h"
#include "ReplaySDK/ContextTreeFunctors.h"
#include "ReplaySDK/FrameUsageTracker.h"
#include "ReplaySDK/memHier2.h"
#include "ReplaySDK/ExcelExport.h"
#include "ReplaySDK/ICSVExporter.h"
#include "ReplaySDK/RangedContextExporter.h"
#include "ReplaySDK/CGFPhysicsExporter.h"
#include "ReplaySDK/ReplayValidator.h"
#include "ReplaySDK/IInterfaceHooks.h"

class ICSVExporter;

class CReplayHandler : public IInterfaceHooks
{
public:
	CReplayHandler( bool verbose = true );
	~CReplayHandler() {};

	bool LoadFile( const char* const pFilename, const char* const pSymbolFilename );
	bool ProcessFile( void );
	bool ExportSummary( const char* const pFilename );

protected:
	SharedPtr<SymbolTableBuilder> ReadSymbolTable(const char* pFilename);
	SharedPtr<ContextTree> ReadContextTree(const char* pFilename);
	SharedPtr<ReplayValidator> ReadValidatorTable(const char* pFilename);
	bool ReadFrameUsages(const char* pFilename);
	void ExportWorksheet(ExcelExport& xls, const SharedPtr<ContextTree>& contextTree, ICSVExporter* exporter );

private:
	bool IsVerbose(void) const { return m_verbose; }

	// IInterfaceHooks methods
	virtual void InvokeOnMainImpl(InvokeHandler handler, void* user);
	virtual void ShowMessageImpl(const TCHAR* msg, const TCHAR* title);
	virtual std::string OpenFileImpl(const char* filter);
	virtual std::string OpenFolderImpl(const TCHAR* title);
	virtual void RunProgressTaskImpl(IProgressTask& task);
	// End IInterfaceHooks methods

	SharedPtr<ReplayLogReader> m_replayStream;
	SharedPtr<ContextTree> m_assetTree;
	SharedPtr<ReplayValidator> m_validation;
	SharedPtr<SymbolHelper> m_symbols;
	FrameUsageTracker m_frameUsage;

	SharedPtr<ContextTree> m_physicsTree;
	SharedPtr<ContextTree> m_textureTree;
	SharedPtr<ContextTree> m_renderMeshTree;
	SharedPtr<ContextTree> m_terrainTree;
	SharedPtr<ContextTree> m_animationTree;
	SharedPtr<ContextTree> m_navTree;
	SharedPtr<ContextTree> m_entTree;
	SharedPtr<ContextTree> m_overviewTree;

	bool m_verbose;
};

#endif
