#ifndef __PREDICTION_HUB__
#define __PREDICTION_HUB__

#include "httpd.h"
#include "image.h"
#include "Predictor.h"

class CPredictionHub : public IServlet
{
private: 
	typedef std::map<std::string, struct IPredictorCreator*> PredictorMap;
public:
	void	Get(CHTTPOutput *pOut, const IServlet::ParamsMap &params);
	void	ShowSetupPage(CHTTPOutput *pOut, const std::string& err);
	void 	ProcessData(const string& file, const string& predictor, bool reset, const string& zoom, const string& cap);
	void	ShowResultsPage(CHTTPOutput *pOut);
	void	ShowResultsImage(CHTTPOutput *pOut);
	void	Draw(const char* zoom, int cap);

	const SVec3 * GetSamples() const { if (m_result.m_err.m_err.empty()) return NULL; return &m_result.m_err.m_err[0]; }
	size_t GetNumSamples() const { return m_result.m_err.m_err.size(); }

	static PredictorMap& GetPredictorMap() { return s_predictors; }

private:
	class CDeltaError;
	struct	SErrorData
	{
		std::vector<SVec3>	m_err;
		SVec3				m_min;
		SVec3				m_max;
	};
	struct	SResults
	{
		SResults():image(600,600,iRGB(0,0,0)),entities(0),samples(0),tot_err(0.0f,0.0f,0.0f) {}
		string filename;
		string predictor;
		CImage<iRGB>	image;
		uint32			samples;
		uint32			total_samples;
		uint32			entities;
		uint32			maxcount;
		uint32			maxshown;
		SVec3			min_err;
		SVec3			max_err;
		SVec3     tot_err;
		SErrorData		m_err;
	};
	SResults			m_result;

	static PredictorMap s_predictors;
};

struct SPredictorParams
{
	SPredictorParams() : dim(0), bits(0), steps(0), maxValue(0.0f), pHub(NULL) {}
	std::string name;
	int dim;
	int bits;
	int steps;
	float maxValue;
	std::string input;
	std::string policyName;
	_smart_ptr<CPredictionHub> pHub;
};

#endif /*__PREDICTION_HUB__*/

