#ifndef __PREDICTOR_H__
#define __PREDICTOR_H__

#include "PredictionHub.h"

template<class T>
struct IPredictor
{
	virtual void Value(const T& x) = 0;//puts real value
	virtual bool Predict(T& y) = 0;//returns true if prediction has been made
	virtual ~IPredictor(){}
};

struct IPredictorCreator
{
	virtual IPredictor<SVec3>* Create() = 0;
};

//typedef IPredictor<SVec3>* (*PredictorCreator)();

#endif /*__PREDICTOR_H__*/

