#ifndef __VERLETPREDICTOR_H__
#define __VERLETPREDICTOR_H__

#include "Predictor.h"

#pragma once

template<class T>
struct VerletPredictor : public IPredictor <T>
{
	VerletPredictor():m_values(0)
	{

	}

	virtual void Value(const T& x)
	{
		m_y = m_x;
		m_x = x;
		m_values++;
	}

	virtual bool Predict(T& y)
	{
		if(m_values<2)
			return false;
		SVec3 pred = m_x-m_y+m_x;
		y = y - pred;
		return true;
	}

	T		m_x;
	T		m_y;
	size_t	m_values;
};

class CVerletPredictorCreator : public IPredictorCreator
{
public:
	IPredictor<SVec3>* Create()
	{
		return new VerletPredictor<SVec3>;
	}

private:
	CVerletPredictorCreator()
	{
		CPredictionHub::GetPredictorMap()["Verlet"] = this;
	}

	static CVerletPredictorCreator s_singleton;
};

#endif /*__VERLETPREDICTOR_H__*/

