#ifndef __APPTASKER_H__
#define __APPTASKER_H__

#include "thread.h"
#include "util.h"
#include "datacollector.h"
#include "statscollector.h"

class CAppTasker
{
public:
	CAppTasker();
	~CAppTasker();

private:
	SOCKET m_sock;
	CThread m_thread;
	CThread m_incoming;
	CStatsCollector m_stats;

	volatile LONG LastSessionId;

	static void ThreadMain( void * p );
	void Main();

	struct ReceiverParams
	{
		CAppTasker * pTasker;
		SOCKET sock;
		sockaddr_in addr;
	};

	static void ThreadIncoming( void * p );
	void Incoming();

	static void ThreadReceiver( void * p );
	void Receiver( ReceiverParams * );

	void Dispatch_DataEnt(uint32 session_id, Socket& sk, const sockaddr_in& addr );
	void Dispatch_EncodingEnt(uint32 session_id, Socket& sk, const sockaddr_in& addr );
	void Dispatch_KeepAlive(uint32 session_id, Socket& sk, const sockaddr_in& addr ) {}
	void Dispatch_SessionId(uint32 session_id, Socket& sk, const sockaddr_in& addr );
	void Dispatch_Stats(uint32 session_id, Socket& sk, const sockaddr_in& addr );
	void Dispatch_Snapping(uint32 session_id, Socket& sk, const sockaddr_in& addr);

	std::map<uint32, CDataCollector*> m_dataCollectors; // session based

	struct SMinMax
	{
		SMinMax() : mn(0.0f), mx(0.0f), nbits(0) {}
		float mn, mx;
		int nbits;
	};

	struct SMinMax3
	{
		SMinMax x;
		SMinMax y;
		SMinMax z;
	};

	typedef uint32 TPolicy;
	typedef std::map<TPolicy, SMinMax3> TPolicyMinMaxMap;
	TPolicyMinMaxMap m_policyMinMaxMap;

	FILE* m_reportMinMax;

	std::map<uint32, FILE*> m_snappingReports; // session based
};

#endif
