#ifndef CONFIG_H
#define CONFIG_H

#include "httpd.h"
#include "tinyxml/tinyxml.h"

struct SConfig
{
	SConfig();
	bool streamAnalysis;
	bool logSync;
	bool hostFilter;
	bool statsCollector;
	bool sampleCompression;
	bool snapping;
	std::vector<std::string> hosts;
	TiXmlDocument policiesXml;
	TiXmlDocument schedulerXml;
	TiXmlDocument entitySchedulerXml;
	float samplingThreshold;
};

SConfig GetConfig(bool reload = false);

void RegisterConfigPages(CHTTPD * pHTTPD);

#endif
