#include "stdafx.h"
#include "email.h"
#include "thread.h"
#include <vector>
#include <string>
#include <process.h>
#include <iostream>
#include "util.h"

#define EMAIL_SERVER "mail:25"

struct EmailData
{
	std::vector<std::string> to;
	std::string message;
};

char GetCharFrom( SOCKET sock )
{
	while (true)
	{
		fd_set fds;
		FD_ZERO(&fds);
		FD_SET(sock, &fds);
		timeval timeout;
		timeout.tv_sec = 300;
		timeout.tv_usec = 0;
		// not portable to *nix
		int n = select(SOCKET(0), &fds, NULL, NULL, &timeout);
		switch (n)
		{
		case 0:
			throw std::runtime_error("Timeout on socket");
		case SOCKET_ERROR:
			throw std::runtime_error("Error waiting for read on socket");
		}
		char output;
		int r = recv( sock, (char*) &output, 1, 0 );
		if (r == SOCKET_ERROR)
		{
			if (WSAGetLastError() != WSAEWOULDBLOCK)
				continue;
			throw std::runtime_error("Error in WSARecv");
		}
		else if (r)
		{
			return output;
		}
		else
		{
			if (WSAGetLastError() != WSAEWOULDBLOCK)
				continue;
			throw std::runtime_error("No bytes received by recv");
		}
	}
}

std::string ReadResponse( SOCKET sock )
{
	std::string input;
	char c;
	do 
	{
		c = GetCharFrom(sock);
		input += c;
	} while (c != '\n');
	while (!input.empty() && (input[input.length()-1] == '\r' || input[input.length()-1] == '\n'))
		input.resize(input.length()-1);
	return input;
}

void CheckResponse( SOCKET sock )
{
	std::string response = ReadResponse(sock);

	if (response.length() < 3)
		throw std::runtime_error("Response too short: " + response);
	if (!isdigit(response[0]) || !isdigit(response[1]) || !isdigit(response[2]) || !isspace(response[3]))
		throw std::runtime_error("Response malformed: " + response);

	int code = (response[0] - '0')*100 + (response[1] - '0')*10 + (response[2] - '0');

	switch (code)
	{
	case 220:
	case 250:
	case 354:
		break;

	default:
		throw std::runtime_error("Bad response: " + response);
	}
}

void SendCommand( SOCKET sock, std::string request )
{
	request += "\r\n";
	send( sock, request.c_str(), request.length(), 0 );

	try
	{
		CheckResponse(sock);
	}
	catch (std::exception& e)
	{
		request.resize(request.length() - 2);
		throw std::runtime_error( e.what() + std::string("\nIn response to ") + request );
	}
}

void SendEmail( void * ptr )
{
	std::auto_ptr<EmailData> pEmail( static_cast<EmailData*>(ptr) );

	try
	{
		bool sockOk = false;
		SOCKET sock;
		for (int i=0; i<5; i++)
		{
			sock = socket( AF_INET, SOCK_STREAM, IPPROTO_TCP );
			if (sock != INVALID_SOCKET)
			{
				sockOk = true;
				break;
			}
			Sleep(1000);
		}
		if (!sockOk)
			throw std::runtime_error("Failed creating socket");

		try
		{
			bool ok = false;
			for (int i=0; i<5; i++)
			{
				sockaddr_in saddr = AddrFromString(EMAIL_SERVER);
				if (0 == connect( sock, (sockaddr*)&saddr, sizeof(saddr) ))
				{
					ok = true;
					break;
				}
				Sleep(1000);
			}
			if (!ok)
				throw std::runtime_error("Failed connecting to " + std::string(EMAIL_SERVER));

			SendCommand(sock, "HELO mail");
			for (std::vector<std::string>::const_iterator iterTo = pEmail->to.begin(); iterTo != pEmail->to.end(); ++iterTo)
			{
				SendCommand(sock, "MAIL FROM:<craig@crytek.de>");
				SendCommand(sock, "RCPT TO:<" + *iterTo + ">");
				SendCommand(sock, "DATA");
				std::string message = "Subject: Network Stream Analysis Notification\r\n\r\n" + pEmail->message;
				SendCommand(sock, message + "\r\n.");
			}
			SendCommand(sock, "QUIT");
		}
		catch (...)
		{
			closesocket( sock );
			throw;
		}
		closesocket( sock );
	}
	catch (std::exception& e)
	{
		SCOPED_GLOBAL_LOCK;
		std::cout << "Emailing exception: " << e.what() << std::endl;
	}
}

void Email( const std::string& message )
{
	EmailData * pEmail = new EmailData;

	pEmail->to.push_back( "craig" );
	pEmail->message = message;

	_beginthread( SendEmail, 0, pEmail );
}
