# Common definitions for all makefiles.

ifndef BASEDIR
  $(error BASEDIR not defined)
endif

# The build directory.
MT_BUILD_DIR = $(BASEDIR)/build/$(TARGET_SYSTEM)

# The base directory holding the mtrace sources.
MT_BASEDIR := $(shell cd '$(BASEDIR)/..' && pwd -W)

ifdef TARGET_SYSTEM
  ifndef HOST_SYSTEM
    $(error HOST_SYSTEM not defined)
  endif
endif

ifneq (,$(findstring LINUX,$(HOST_SYSTEM)))
  $(info loading linux definitions)
  include Linux.mk
endif 

ifneq (,$(findstring WIN,$(HOST_SYSTEM)))
  $(info loading windows definitions)
  include Windows.mk
endif 
