#!/bin/sh
#
# Determine the host system ID (in upppercase) through 'uname'.

HOST_SYSTEM=
case `uname -s` in
MINGW32_NT-6.1) 
  HOST_SYSTEM=WIN32;;
Linux)
  case `uname -m` in
  x86_64) HOST_SYSTEM=LINUX_X86_64;;
  i?86|x86) HOST_SYSTEM=LINUX_X86;;
  esac
esac

if [ -z "$HOST_SYSTEM" ]; then
  echo "$0: unrecognized host system" >&2
  exit 1
fi
echo $HOST_SYSTEM
exit 0

