# Windows.mk 
# 
# Makefile definitions for windows host && target systems
#

OBJ_EXT = obj
EXE_EXT = .exe

BOOST_INCLUDE_DIR = E:/SDKS/boost_1_38/
BOOST_LIB_DIR = E:/SDKS/boost_1_38/lib

CC = cl.exe
CXX = cl.exe
LD = link.exe
AR = lib.exe
STD_LIBS = Ws2_32.lib User32.lib

CPPFLAGS = \
	/I$(BASEDIR)/include  \
	/I$(BOOST_INCLUDE_DIR) \
	/DBOOST_LIB_DIAGNOSTIC \
	/DTARGET_SYSTEM_$(TARGET_SYSTEM) \
	/DTARGET_SYSTEM='"$(TARGET_SYSTEM)"' \
	/I$(BASEDIR) /I$(MT_BUILD_DIR) \
	/DWIN32 /D_CONSOLE /D_CRT_SECURE_NO_WARNINGS \
	/D_SCL_SECURE_NO_WARNINGS=0 

DEPFLAGS := \
	-I$(BASEDIR)/include \
	-I$(BOOST_INCLUDE_DIR) \
	-DBOOST_LIB_DIAGNOSTIC \
	-DTARGET_SYSTEM_$(TARGET_SYSTEM) \
	-DTARGET_SYSTEM='"$(TARGET_SYSTEM)"' \
	-I$(BASEDIR) -I$(MT_BUILD_DIR) \
	-DWIN32 -D_CONSOLE -D_CRT_SECURE_NO_WARNINGS \
	-D_SCL_SECURE_NO_WARNINGS=0 -D_SECURE_SCL=0 \
	-p$(MT_BUILD_DIR)/

MAKE = /mingw/bin/mingw32-make.exe
CTAGS = ctags.exe
GTAGS = gtags.exe

LD_FLAGS = /L 
CFLAGS = /nologo
CXXFLAGS = /EHsc /nologo /GR
MAKE_DEPEND := $(BASEDIR)/tools/makedepend.exe
MAKE_DEPEND_ERROR_FILE = $(MT_BUILD_DIR)/makedep.errors

ifndef RELEASE
  CPPLFAGS += /D_DEBUG
  LD_FLAGS += /MTd /DEBUG
  CFLAGS += /Od /Z7 /MTd
else
  CPPLFAGS += /DNDEBUG=1
  LD_FLAGS += /MT
  CFLAGS += /Ox /Z7 /MT
endif


MTRACEDB_LIB = $(MT_BUILD_DIR)/libps3mtrace.lib

define compile_cc
MT_CC_$1_DEP_FILE = $(patsubst %.cc,$$(MT_BUILD_DIR)/%.d,$1)
MT_CC_$1_OBJ_FILE = $(MT_BUILD_DIR)/$(patsubst %.cc,%.$(OBJ_EXT),$1)
-include $$(MT_CC_$1_DEP_FILE)
$(MT_BUILD_DIR)/$(patsubst %.cc,%.$(OBJ_EXT),$(1)): $(1)
	@ mkdir -p $$(dir $$@)
	@ $$(RM) $$@
	@ touch $$(MT_CC_$1_DEP_FILE)
	$$(MAKE_DEPEND) $$(DEPFLAGS) -f$$(MT_CC_$1_DEP_FILE) $$< \
		2&>1 
	$$(CXX) \
	  $$(CPPFLAGS) $$(CFLAGS) $$(CXXFLAGS) /Fo$$@ /c $$<
endef

define link_executable
	@ mkdir -p $(dir $@)
	@ $(RM) $@
	$(LD) /DEBUG /LIBPATH:$(BOOST_LIB_DIR) /nologo /OUT:$@ $^ $(STD_LIBS)
endef

define link_lib
	@ mkdir -p $(dir $@)
	@ $(RM) $@
	$(AR) /nologo /OUT:$@ $^
endef



