//////////////////////////////////////////////////////////////////////////////
//
// Crytek Source File.
// Copyright (C), Crytek Studios, 2007.
// ---------------------------------------------------------------------------
// Description:
// Process communication helpers
// ---------------------------------------------------------------------------
// History:
// - June 30 2009 - Created by Christopher Raine 
//////////////////////////////////////////////////////////////////////////////
#ifndef __PROCESS_H
#define __PROCESS_H

namespace mtracedb 
{
	// This class can spawn a child process with redirected 
	// input,output and error streams and therefore provide a methods of
	// communicating with the child process.
	class process_t
	{
		// Defined in process.cc
		class internals; 

		// Pointer to the process internals inside 
		internals* m_process_internals;

	public:
		// Handles for the input/output and error streams 
		enum STREAM_KIND 
		{ STREAM_INPUT = 0,	STREAM_OUTPUT = 1, STREAM_ERROR = 2 }; 

		// Constructor
		process_t();

		// Destructor
		~process_t(); 

		// Run a process (command line arguments given as paramters)
		bool run(int argc, const char* argv[]);

		// Close a running process (?!)
		bool close();

		// Returns false if the process is still running
		bool has_exited() const;

		// Returns true if there has been an error
		bool has_error() const;

		// Write to a stream 
		size_t write(STREAM_KIND, const void*, size_t);

		// Write from a stream 
		size_t read(STREAM_KIND, void*, size_t);

    // Retrieve the number of bytes available on the output buffer
    size_t process_t::peak(STREAM_KIND);
	}; 
}; 

#endif 
