#include "stdafx.h"
#include <algorithm>

#include "Fragmentation.h"

CFragmentation::CFragmentation()
  : m_lower_bound(~0U), 
    m_upper_bound(0)
{}

CFragmentation::~CFragmentation()
{
}

void CFragmentation::on_alloc(address_t ptr, const size_t size)
{
  boost::unique_lock<boost::mutex> lock(m_mutex);

  range_t r; r.ptr = ptr; r.size = size; 
  range_vec_t::iterator where = std::lower_bound(
    m_allocated.begin(), m_allocated.end(), r, less()); 
  m_allocated.insert(where, r); 

  if (m_lower_bound > ptr) m_lower_bound = ptr; 
  if (m_upper_bound < ptr+size) m_upper_bound = ptr+size; 

  // Split freed chunk if being reused
  range_vec_t::iterator freed = std::upper_bound(
    m_freed.begin(), m_freed.end(), r, less()); 
  if (freed != m_freed.end() && 
    freed->ptr<=r.ptr &&
    freed->ptr+size>=ptr+size)
  {
    if (r.ptr - freed->ptr) 
    {
      freed->size = r.ptr - freed->ptr; 

      if (freed->ptr+freed->size - size) 
      { 
        range_t after; 
        after.ptr = ptr + size; 
        after.size = freed->ptr+freed->size - size;  
        m_freed.insert(freed+1, after); 
      }
    }
    else if (freed->ptr+freed->size - size)
    {
      freed->ptr = ptr + size; 
      freed->size = freed->ptr+freed->size - size;  
    }
    else 
      m_freed.erase(freed);
  }

}
void CFragmentation::on_free(address_t ptr)
{
  boost::unique_lock<boost::mutex> lock(m_mutex);

  range_vec_t::iterator where = std::lower_bound(
    m_allocated.begin(), m_allocated.end(), ptr, less()); 
  if (where != m_allocated.end() && where->ptr == ptr) 
  { 
    range_t& r = *where; 
    range_vec_t::iterator it = std::lower_bound(
      m_freed.begin(), m_freed.end(), r, less()); 
    m_freed.insert(it, r); 

    m_allocated.erase(where); 
  } 
}

void CFragmentation::update_scene()
{
  boost::unique_lock<boost::mutex> lock(m_mutex);
  if (m_upper_bound <= m_lower_bound) return; 

	CRect rcClient;
	GetClientRect(rcClient);

  const size_t range = m_upper_bound - m_lower_bound; 
  const size_t alloced = m_allocated.size();
  const size_t freed = m_freed.size();
  size_t height = rcClient.Height();
  const size_t width = rcClient.Width();
  const size_t scan_len = (256<<10); 
  const size_t scan_width = scan_len; 
  const float byte_size = 20.f / (float)(scan_len); 
  const float byte_height = 20.f / (float)(range/scan_len); 


  vec2 ul, br;
  ul.x = 0.f; ul.y = 0.f;
  br.x = 10.f; br.y = 10.f;
  //draw_box(ul, br, Yellow); 

  for (size_t i=0; i<alloced; ++i) 
  { 
    const range_t& r = m_allocated[i]; 
    const size_t s = r.ptr - m_lower_bound; 
    const size_t e = s+r.size; 
    const size_t sy_b = s / scan_width;
    const size_t sy_e = e / scan_width; 
    size_t k = s; 

    for (size_t j=sy_b; j<=sy_e; ++j)
    {
      const size_t scan_x = k % scan_width; 
      const size_t scan_w = (e-j*scan_width>scan_width) ? scan_width : e-j*scan_width; 

      ul.x = (float)scan_x * byte_size; 
      ul.y = (float)j * byte_height; 
      br.x = (float)scan_w * byte_size; 
      br.y = (float)(j+1) * byte_height; 

      draw_box(ul, br, RED); 
      k+=(scan_w-scan_x); 
    }
  } 

  for (size_t i=0; i<freed; ++i) 
  { 
    const range_t& r = m_freed[i]; 
    const size_t s = r.ptr - m_lower_bound; 
    const size_t e = s+r.size; 
    const size_t sy_b = s / scan_width;
    const size_t sy_e = e / scan_width; 
    size_t k = s; 

    for (size_t j=sy_b; j<=sy_e; ++j)
    {
      const size_t scan_x = k % scan_width; 
      const size_t scan_w = (e-j*scan_width>scan_width) ? scan_width : e-j*scan_width; 

      ul.x = (float)scan_x * byte_size; 
      ul.y = (float)j * byte_height; 
      br.x = (float)scan_w * byte_size; 
      br.y = (float)(j+1) * byte_height; 

      draw_box(ul, br, GREEN); 
      k+=(scan_w-scan_x); 
    }
  } 

  print(0, height -= 20, WHITE, "Fragementation... [0x%x - 0x%x] allocs:%d freed:%d", 
    m_lower_bound, m_upper_bound, alloced, freed); 


}


