#pragma once 

#include "oglWnd.h"
#include <mtracedb/mtracedb.h>

using mtracedb::address_t; 

struct range_t 
{ 
  address_t ptr; 
  size_t size; 
  
  bool operator< (const range_t& other) const 
  { return ptr < other.ptr; }  

  bool operator== (const range_t& other) const 
  { return ptr == other.ptr && size == other.size; }  

  bool operator!= (const range_t& other) const 
  { return !(*this == other); }  
};

typedef std::vector<range_t> range_vec_t;

struct less 
{ 
  bool operator() (const range_t& a, const range_t& b) const 
  { return a.ptr < b.ptr; } 

  bool operator() (address_t ptr, const range_t& other) const 
  { return ptr < other.ptr; } 
  
  bool operator() (const range_t& other, address_t ptr) const
  { return other.ptr < ptr; } 
};

class CFragmentation : public CGLWnd, public mtracedb::memory_callback
{
public:
  CFragmentation();
  virtual ~CFragmentation(); 

  void on_alloc(address_t ptr, const size_t size); 
  void on_free(address_t ptr);

private:

  void update_scene(); 

  address_t m_lower_bound; 
  address_t m_upper_bound; 

  range_vec_t m_allocated; 
  range_vec_t m_freed; 
}; 
