
// MAnalyzeDoc.cpp : implementation of the CMAnalyzeDoc class
//

#include "stdafx.h"
#include "MAnalyze.h"

#include "MAnalyzeDoc.h"

#include <boost/filesystem.hpp>
namespace fs = boost::filesystem; 
using mtracedb::cerr;
using mtracedb::out;

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CMAnalyzeDoc

IMPLEMENT_DYNCREATE(CMAnalyzeDoc, CDocument)

BEGIN_MESSAGE_MAP(CMAnalyzeDoc, CDocument)
END_MESSAGE_MAP()


// CMAnalyzeDoc construction/destruction

CMAnalyzeDoc::CMAnalyzeDoc()
: m_storage(),
  m_memory(),
  m_mtrace_thread() 
{
}

CMAnalyzeDoc::~CMAnalyzeDoc()
{
  Shutdown();
}

void CMAnalyzeDoc::Shutdown()
{
  mtracedb::s_exit_request = true; 
  m_mtrace_thread.join(); 
  mtracedb::s_exit_request = false; 

  delete m_storage;
  delete m_memory;
}

void CMAnalyzeDoc::register_callback(mtracedb::stats_callback* cb)
{
  m_callbacks.stats_cbs.push_back(cb);
}

void CMAnalyzeDoc::register_callback(mtracedb::memory_callback* cb)
{
  m_callbacks.memory_cbs.push_back(cb);
}

BOOL CMAnalyzeDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

  Shutdown();

  mtracedb::options& opts = mtracedb::get_options(); 

  fs::path dir = opts.data_directory;
  if (!fs::exists(dir)) 
  { 
    if (!fs::create_directory(dir))
    {
      cerr() << " could not create directory" << dir <<
        std::endl; 
      return FALSE; 
    }
  } 

  fs::path elf_file = opts.elf_file;
  if (!fs::exists(elf_file))
  {
    cerr() << " elf file does not exist " << elf_file <<
      std::endl; 
    return FALSE; 
  }

  fs::path new_elf = dir / elf_file.filename();
  if (fs::exists(new_elf))
    fs::remove(new_elf);
  fs::copy_file(elf_file, new_elf); 
  opts.elf_file = new_elf.file_string();

  // Allocate the storage members 
  m_storage = new mtracedb::storage_t(opts.data_directory, true); 
  m_memory = new mtracedb::memory_t(m_storage); 

  // Create the netpump thread 
  m_mtrace_thread = boost::thread(
    mtracedb::netpump, 
    boost::ref(*m_storage),
    boost::ref(*m_memory), 
    boost::ref(m_callbacks));

	return TRUE;
}


// CMAnalyzeDoc serialization

void CMAnalyzeDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: add storing code here
	}
	else
	{
		// TODO: add loading code here
	}
}


// CMAnalyzeDoc diagnostics

#ifdef _DEBUG
void CMAnalyzeDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CMAnalyzeDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

BOOL CMAnalyzeDoc::OnOpenDocument(LPCTSTR lpszPathName)
{
  if (!CDocument::OnOpenDocument(lpszPathName))
    return FALSE;

  mtracedb::options& opts = mtracedb::get_options(); 

  fs::path dir = lpszPathName;
  if (!fs::exists(dir)) 
  { 
    cerr() << " could not open directory" << dir <<
      std::endl; 
    return FALSE; 
  } 

  fs::path elf_file = opts.elf_file;
  if (!fs::exists(elf_file))
  {
    cerr() << " elf file does not exist " << elf_file <<
      std::endl; 
    return FALSE; 
  }

  fs::path new_elf = dir / elf_file.filename();
  if (fs::exists(new_elf))
    fs::remove(new_elf);
  fs::copy_file(elf_file, new_elf); 
  opts.elf_file = new_elf.file_string();

  // Allocate the storage members 
  m_storage = new mtracedb::storage_t(opts.data_directory, false); 
  m_memory = new mtracedb::memory_t(m_storage); 

  return TRUE;
}


// CMAnalyzeDoc commands
