
// MAnalyzeDoc.h : interface of the CMAnalyzeDoc class
//

#pragma once

#include <boost/thread.hpp>
#include <mtracedb/mtracedb.h>

class CMAnalyzeDoc : public CDocument
{
protected: // create from serialization only
	CMAnalyzeDoc();
	DECLARE_DYNCREATE(CMAnalyzeDoc)

// Attributes
public:

// Operations
public:

  // Register the callbacks for memory and statistics
  void register_callback(mtracedb::stats_callback*); 
  void register_callback(mtracedb::memory_callback*); 

// Overrides
public:
  void Shutdown();
	virtual BOOL OnNewDocument();
	virtual void Serialize(CArchive& ar);

// Implementation
public:
	virtual ~CMAnalyzeDoc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

  mtracedb::storage_t *m_storage;
  mtracedb::memory_t *m_memory;
  mtracedb::callback_handler m_callbacks; 
  boost::thread m_mtrace_thread; 

// Generated message map functions
protected:
	DECLARE_MESSAGE_MAP()
public:
  virtual BOOL OnOpenDocument(LPCTSTR lpszPathName);
};


