
// MAnalyzeView.cpp : implementation of the CMAnalyzeView class
//

#include "stdafx.h"
#include "MAnalyze.h"

#include "MAnalyzeDoc.h"
#include "MAnalyzeView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CMAnalyzeView

IMPLEMENT_DYNCREATE(CMAnalyzeView, CView)

BEGIN_MESSAGE_MAP(CMAnalyzeView, CView)
	ON_WM_CREATE()
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, &CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, &CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, &CMAnalyzeView::OnFilePrintPreview)
  ON_WM_SIZE()
END_MESSAGE_MAP()

// CMAnalyzeView construction/destruction

CMAnalyzeView::CMAnalyzeView()
{
	// TODO: add construction code here

}

CMAnalyzeView::~CMAnalyzeView()
{
}

BOOL CMAnalyzeView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs
	return CView::PreCreateWindow(cs);
}

int CMAnalyzeView::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
  int result = CView::OnCreate(lpCreateStruct);

	CRect rectDummy;
	rectDummy.SetRectEmpty();

	// Create tabs window:
	if (!m_tabWnd.Create(CMFCTabCtrl::STYLE_FLAT, rectDummy, this, 1))
	{
		TRACE0("Failed to create output tab window\n");
		return -1;      // fail to create
	}

	if (!m_GraphWnd.Create("Graph", "Graph", WS_CHILD | WS_VISIBLE, rectDummy, &m_tabWnd, 2))
	{
		TRACE0("Failed to create output tab window\n");
		return -1;      // fail to create
	}
  m_tabWnd.AddTab( &m_GraphWnd, "Graph", (UINT)-1);
  GetDocument()->register_callback(&m_GraphWnd);


	if (!m_FragmentWnd.Create("Fragmentation", "Fragmentation", WS_CHILD | WS_VISIBLE, rectDummy, &m_tabWnd, 2))
	{
		TRACE0("Failed to create output tab window\n");
		return -1;      // fail to create
	}
  m_tabWnd.AddTab( &m_FragmentWnd, "Fragmentation", (UINT)-1);
  GetDocument()->register_callback(&m_FragmentWnd);


  m_tabWnd.SetDrawFrame();
 

  return result; 
}

// CMAnalyzeView drawing

void CMAnalyzeView::OnDraw(CDC* pDC)
{
	CMAnalyzeDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	if (!pDoc)
		return;
}


// CMAnalyzeView printing


void CMAnalyzeView::OnFilePrintPreview()
{
	AFXPrintPreview(this);
}

BOOL CMAnalyzeView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CMAnalyzeView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CMAnalyzeView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

void CMAnalyzeView::OnRButtonUp(UINT nFlags, CPoint point)
{
	ClientToScreen(&point);
	OnContextMenu(this, point);
}

void CMAnalyzeView::OnContextMenu(CWnd* pWnd, CPoint point)
{
	theApp.GetContextMenuManager()->ShowPopupMenu(IDR_POPUP_EDIT, point.x, point.y, this, TRUE);
}


// CMAnalyzeView diagnostics

#ifdef _DEBUG
void CMAnalyzeView::AssertValid() const
{
	CView::AssertValid();
}

void CMAnalyzeView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CMAnalyzeDoc* CMAnalyzeView::GetDocument() const // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CMAnalyzeDoc)));
	return (CMAnalyzeDoc*)m_pDocument;
}
#endif //_DEBUG


// CMAnalyzeView message handlers

void CMAnalyzeView::OnSize(UINT nType, int cx, int cy)
{
  CView::OnSize(nType, cx, cy);
	m_tabWnd.SetWindowPos(NULL, -1, -1, cx, cy, SWP_NOMOVE | SWP_NOACTIVATE | SWP_NOZORDER);
}
