
// MAnalyzeView.h : interface of the CMAnalyzeView class
//
#include "MemoryGraph.h"
#include "Fragmentation.h"

#pragma once


class CMAnalyzeView : public CView
{
protected: // create from serialization only
	CMAnalyzeView();
	DECLARE_DYNCREATE(CMAnalyzeView)

// Attributes
public:
	CMAnalyzeDoc* GetDocument() const;

// Operations
public:

// Overrides
public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
protected:
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);

// Implementation
public:
	virtual ~CMAnalyzeView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif


protected:

	CMFCTabCtrl	m_tabWnd;
  CMemoryGraph m_GraphWnd;
  CFragmentation m_FragmentWnd;

// Generated message map functions
protected:
  afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnFilePrintPreview();
	afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
	DECLARE_MESSAGE_MAP()
public:
  afx_msg void OnSize(UINT nType, int cx, int cy);
};

#ifndef _DEBUG  // debug version in MAnalyzeView.cpp
inline CMAnalyzeDoc* CMAnalyzeView::GetDocument() const
   { return reinterpret_cast<CMAnalyzeDoc*>(m_pDocument); }
#endif

