#include "stdafx.h"
#include "MemoryGraph.h"

namespace
{
  static const size_t s_max_samples = 4<<20;
}

CMemoryGraph::CMemoryGraph() 
  : m_inserter(0)
{
  m_stats.resize(s_max_samples); 
  std::memset(
    &(*m_stats.begin()), 
    0x0,
    sizeof(mtracedb::BriefSystemStats)*s_max_samples);
}
CMemoryGraph::~CMemoryGraph() {}

void CMemoryGraph::on_snapshot(const std::string& name)
{
  boost::unique_lock<boost::mutex> lock(m_mutex);
  m_snapshots.push_back(std::make_pair(m_inserter, name));
}

void CMemoryGraph::on_stats(const mtracedb::BriefSystemStats& stats)
{
  boost::unique_lock<boost::mutex> lock(m_mutex);
  m_stats[m_inserter++] = m_last_stats = stats;
  if (m_inserter >= s_max_samples) m_inserter = 0;
}

void CMemoryGraph::update_scene()
{
  boost::unique_lock<boost::mutex> lock(m_mutex);

	CRect rcClient;
	GetClientRect(rcClient);

  const size_t num_stats = m_stats.size(); 
  unsigned height = rcClient.Height();
  const unsigned width = rcClient.Width();
  const unsigned samples = width; 
  const float sample_width = 20.f/((float)num_stats);
  const float sample_height = 20.f/((float)(128U<<20));

  const float window_width = m_clip.br.x - m_clip.ul.x; 
  const float sample_step = window_width / (float)samples; 
  const float window_begin = clamp_pos(m_clip.ul.x) / sample_width;
  const float window_end = clamp_pos(m_clip.br.x) / sample_width;
  const size_t i=static_cast<size_t>(window_begin);
  const size_t j=static_cast<size_t>(window_end);
  const size_t step=(j-i>samples) ? (j-i)/samples : 1; 

  vec2 total; 
  vec2 last_sample[16]; 

  for (size_t x=i,s=0; x<j; x+=step)
  { 
    if (x >= num_stats) break; 

    const mtracedb::BriefSystemStats& stats = m_stats[x]; 
    for (unsigned k=0; k<16; ++k)
    {
      vec2 &start = last_sample[k], end; 
      size_t allocated = stats.modules[k];

      end.x = (float)x * sample_width; 
      end.y = (float)allocated * sample_height; 
      draw_line(start, end, s_mod_colours[k]); 
      start = end; 
    }

    vec2 end; 
    uint32_t allocated = stats.total;

    end.x = (float)x * sample_width; 
    end.y = (float)allocated * sample_height; 
    draw_line(total, end, RED); 
    total = end; 

  } 

  print(0, height -= 20, WHITE, "MemoryGraph... %3.3f %3.3f %d:i %d:j", 
    m_transform.x, m_transform.x, i, j); 

  uint32_t mod_sum = 0; 
  for (unsigned k=0; k<16; ++k) mod_sum += m_last_stats.modules[k]; 

  print(0, height-=20, RED, "total allocated: %3.3f mb (delta %3.3f)", 
    (float)m_last_stats.total / (1024.f*1024.f), 
    ((float)m_last_stats.total-(float)mod_sum) / (1024.f*1024.f));
  
  for (unsigned k=0; k<16; ++k) 
    print(0, height-=20, s_mod_colours[k], "%s allocated: %3.3f mb", 
      to_string((mtracedb::ECryModule)k), (float)m_last_stats.modules[k] / (1024.f*1024.f));

  print(0, height-=20, Yellow, "unknown allocated: %3.3f mb", 
      (float)m_last_stats.unknown / (1024.f*1024.f));

}



