#include "stdafx.h"
#include "OnIdle.h"
#include <vector>
#include <algorithm>

namespace 
{
  static std::vector<idle_callback*> s_idlers; 
}

idle_callback::idle_callback() 
{ s_idlers.push_back(this); }

idle_callback::~idle_callback() 
{ 
  s_idlers.erase(
    std::remove(s_idlers.begin(), s_idlers.end(), this), 
    s_idlers.end()); 
}

void idle_callback::idle_event()
{
  for (
    std::vector<idle_callback*>::iterator it = s_idlers.begin(); 
    it != s_idlers.end(); 
    ++it) 
  { 
    (*it)->on_idle(); 
  } 
}
