#include "stdafx.h"
#include "TimeSliderWnd.h"

BEGIN_MESSAGE_MAP(CTimeSliderWnd, CDockablePane)
  ON_WM_CREATE()
  ON_WM_SIZE()
  ON_WM_PAINT()
END_MESSAGE_MAP()


CTimeSliderWnd::CTimeSliderWnd()
{
}

CTimeSliderWnd::~CTimeSliderWnd()
{
}

int CTimeSliderWnd::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
  if (CDockablePane::OnCreate(lpCreateStruct) == -1)
    return -1;

	CRect rectDummy;
	rectDummy.SetRectEmpty();

	// Create tabs window:
	if (!m_Slider.Create(WS_CHILD | WS_VISIBLE | TBS_HORZ, rectDummy, this, 5))
	{
		TRACE0("Failed to create output tab window\n");
		return -1;      // fail to create
	}
  // TODO:  Add your specialized creation code here

  AdjustLayout();

  return 0;
}

void CTimeSliderWnd::AdjustLayout()
{
	if (GetSafeHwnd() == NULL)
	{
		return;
	}

	CRect rectClient,rectCombo;
	GetClientRect(rectClient);
	m_Slider.SetWindowPos(NULL, rectClient.left, rectClient.top,
    rectClient.Width(), rectClient.Height(), SWP_NOACTIVATE | SWP_NOZORDER);
}


void CTimeSliderWnd::OnSize(UINT nType, int cx, int cy)
{
  CDockablePane::OnSize(nType, cx, cy);
  AdjustLayout();
  // TODO: Add your message handler code here
}

void CTimeSliderWnd::OnPaint()
{
  CPaintDC dc(this); // device context for painting
	CRect rectTree;
	m_Slider.GetWindowRect(rectTree);
	ScreenToClient(rectTree);

	rectTree.InflateRect(1, 1);
	dc.Draw3dRect(rectTree, ::GetSysColor(COLOR_3DSHADOW), ::GetSysColor(COLOR_3DSHADOW));

  CDockablePane::OnPaint();
}
