#include "stdafx.h"
#include "oglWnd.h"
#include <gl/gl.h>
#include <gl/glu.h>

CGLWnd::CGLWnd()
  : m_transform(-10.0f, -10.0f),
    m_scale(0.1f),
    m_clip()
{
}

CGLWnd::~CGLWnd(void)
{
  glDeleteLists(m_font_base, 256);
}

BEGIN_MESSAGE_MAP(CGLWnd, CWnd)
	ON_WM_PAINT()
	ON_WM_SIZE()
	ON_WM_CREATE()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONDBLCLK()
	ON_WM_MBUTTONDOWN()
	ON_WM_MBUTTONUP()
	ON_WM_MOUSEMOVE()
	ON_WM_MOUSEWHEEL()
	ON_WM_MOUSELEAVE()
END_MESSAGE_MAP()

afx_msg void CGLWnd::OnLButtonDown(UINT nFlags, CPoint point)
{
	CWnd::OnLButtonDown(nFlags, point);
}

afx_msg void CGLWnd::OnLButtonDblClk(UINT nFlags, CPoint point)
{
	CWnd::OnLButtonDblClk(nFlags, point);
}

afx_msg void CGLWnd::OnMButtonDown(UINT nFlags, CPoint point)
{
}

afx_msg void CGLWnd::OnMButtonUp(UINT nFlags, CPoint point)
{
}

afx_msg void CGLWnd::OnMouseMove(UINT nFlags, CPoint point)
{
	CRect rcClient;
	GetClientRect(rcClient);

  static CPoint last_position = CPoint(0,0); 
  if (last_position != CPoint(0,0)) 
  {
    CPoint delta = point - last_position; 
    if (nFlags & MK_LBUTTON) 
    { 
      m_transform.x += ((float)delta.x/(float)rcClient.Width()) * 1.0f/m_scale; 
      m_transform.y -= ((float)delta.y/(float)rcClient.Height()) * 1.0f/m_scale;
      m_transform.x = clamp(m_transform.x, -0.0f, -20.f);
      m_transform.y = clamp(m_transform.y, -0.0f, -20.f);
    }
    if (nFlags & MK_RBUTTON) 
    { 
      m_scale -= (float)delta.y / (float)rcClient.Height(); 
      m_scale = (m_scale < 0.1f) ? 0.1f : (m_scale > 10.f) ? 10.f : m_scale; 
    } 
  }
  last_position = point; 
}

afx_msg BOOL CGLWnd::OnMouseWheel(UINT nFlags, short zDelta, CPoint pt)
{
	return TRUE;
}

void CGLWnd::OnMouseLeave()
{
	CWnd::OnMouseLeave();
}

void CGLWnd::OnPaint()
{
	CPaintDC dc(this);
	GLDrawScene();
}

void CGLWnd::OnSize(UINT nType, int cx, int cy)
{
	CWnd::OnSize(nType, cx, cy);
	if (0 >= cx || 0 >= cy || nType == SIZE_MINIMIZED)
		return;
	Invalidate();
}

int CGLWnd::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CWnd::OnCreate(lpCreateStruct) == -1) return -1;
	GLInitialize();
	return 0;
}

void CGLWnd::GLDrawScene(void)
{
	wglMakeCurrent(hdc, hrc);

	CRect rcClient;
	GetClientRect(rcClient);

	glViewport(0, 0, rcClient.Width(), rcClient.Height());
  glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT|GL_ACCUM_BUFFER_BIT|GL_STENCIL_BUFFER_BIT);

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glMatrixMode(GL_MODELVIEW );
	glLoadIdentity();

  glScalef(m_scale, m_scale, 1.f);
  glTranslatef(m_transform.x, m_transform.y, 0.f);

  m_clip.ul.x = -1.f * 1.f/m_scale - m_transform.x; 
  m_clip.ul.y = 1.f * 1.f/m_scale - m_transform.y;  
  m_clip.br.x = 1.f * 1.f/m_scale - m_transform.x; 
  m_clip.br.y = -1.f * 1.f/m_scale - m_transform.y; 

  glCullFace(GL_FRONT);

  update_scene();

#if 1
  draw_line(vec2(-1.f, 1.f), vec2(1.f, 1.f), GREEN);
  draw_line(vec2(1.f, 1.f), vec2(1.f, -1.f), GREEN);
  draw_line(vec2(1.f, -1.f), vec2(-1.f, -1.f), GREEN);
  draw_line(vec2(-1.f, -1.f), vec2(-1.f, 1.f), GREEN);

  draw_line(vec2(m_clip.ul.x, m_clip.ul.y), vec2(m_clip.ul.x, m_clip.br.y), RED);
  draw_line(vec2(m_clip.ul.x, m_clip.br.y), vec2(m_clip.br.x, m_clip.br.y), RED);
  draw_line(vec2(m_clip.br.x, m_clip.br.y), vec2(m_clip.br.x, m_clip.ul.y), RED);
  draw_line(vec2(m_clip.br.x, m_clip.ul.y), vec2(m_clip.ul.x, m_clip.ul.y), RED);
#endif


	SwapBuffers(hdc);
}

void CGLWnd::update_scene()
{
#if 0
  print(0.f, 0.f, "unscaled 1.f!");
  print(100.f, 100.f,"unscaled 1.f!");
  print(200.f, 200.f,"unscaled 1.f!");
  print(300.f, 300.f,"unscaled 1.f!");

  print(50.f, 0.f, 1.f, "1.f!");
  print(150.f, 100.f, 2.f, "2.f!");
  print(250.f, 200.f, 3.f, "3.f!");
  print(350.f, 300.f, 4.f, "4.f!");

  glBegin(GL_QUADS); 
  glColor3f(1.f, 0.f, 0.f);
  glVertex3f(-1.f, 1.f, 1.f);

  glColor3f(0.f, 1.f, 0.f);
  glVertex3f(1.f, 1.f, 1.f);

  glColor3f(0.f, 0.f, 1.f);
  glVertex3f(1.f, -1.f, 1.f);

  glColor3f(0.f, 0.f, 0.f);
  glVertex3f(-1.f, -1.f, 1.f);
  glEnd(); 
#endif
}

void CGLWnd::print(float x, float y, const colour& c, const char* fmt, ...)
{
	char		text[256];
	va_list		ap;			

	CRect rcClient;
	GetClientRect(rcClient);

	if (fmt == NULL)	
		return;					

	va_start(ap, fmt);
  vsprintf(text, fmt, ap);
	va_end(ap);							

	glMatrixMode(GL_PROJECTION);
  glPushMatrix();
  gluOrtho2D(0, rcClient.Width(), 0, rcClient.Height());

	glMatrixMode(GL_MODELVIEW );
  glPushMatrix();
	glLoadIdentity();
	glTranslatef(x, y, 0.0f);
	glScalef(15.f, 15.f, 1.0f);
  
  glColor3f(c.r, c.g, c.b); 

	glPushAttrib(GL_LIST_BIT);
	glListBase(m_font_base);					
	glCallLists(strlen(text), GL_UNSIGNED_BYTE, text);	
	glPopAttrib();

	glMatrixMode(GL_PROJECTION);
  glPopMatrix();
	glMatrixMode(GL_MODELVIEW );
  glPopMatrix();
}

void CGLWnd::print(float x, float y, float scale, const colour& c, const char* fmt, ...)
{
	char		text[256];
	va_list		ap;			

	CRect rcClient;
	GetClientRect(rcClient);

	if (fmt == NULL)	
		return;					

 	va_start(ap, fmt);
  vsprintf(text, fmt, ap);
	va_end(ap);							

	glMatrixMode(GL_PROJECTION);
  glPushMatrix();
  gluOrtho2D(0, rcClient.Width(), 0, rcClient.Height());

  glMatrixMode(GL_MODELVIEW );
  glPushMatrix();
	glLoadIdentity();
	glTranslatef(x, y, 0.0f);
	glScalef(scale * 15.f, scale * 15.f, 1.0f);

  glColor3f(c.r, c.g, c.b);

	glPushAttrib(GL_LIST_BIT);
	glListBase(m_font_base);					
	glCallLists(strlen(text), GL_UNSIGNED_BYTE, text);	
	glPopAttrib();

	glMatrixMode(GL_PROJECTION);
  glPopMatrix();
	glMatrixMode(GL_MODELVIEW );
  glPopMatrix();
}

void CGLWnd::draw_line(const vec2& start, const vec2& end, const colour& c)
{
  glBegin(GL_LINES); 

  glColor3f(c.r, c.g, c.b);
  glVertex3f(start.x, start.y, 1.f);

  glColor3f(c.r, c.g, c.b);
  glVertex3f(end.x, end.y, 1.f);

  glEnd();
}

void CGLWnd::draw_box(const vec2& start, const vec2& end, const colour& c)
{
  glBegin(GL_QUADS); 
  glColor3f(c.r, c.g, c.b);

  glVertex3f(start.x, start.y, 1.f);
  glVertex3f(end.x, start.y, 1.f);
  glVertex3f(end.x, end.y, 1.f);
  glVertex3f(start.x, end.y, 1.f);

  glEnd(); 
}


BOOL CGLWnd::Create(LPCTSTR lpszClassName, LPCTSTR lpszWindowName, DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID, CCreateContext* pContext /* = NULL */)
{
	GLCreate(rect, pParentWnd, nID);
	return TRUE;
}

BOOL CGLWnd::CreateEx(DWORD dwExStyle, LPCTSTR lpszClassName, LPCTSTR lpszWindowName, DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID, LPVOID lpParam /* = NULL */)
{
	GLCreate(rect, pParentWnd, nID);
	return TRUE;
}

void CGLWnd::GLCreate(CRect rect, CWnd *parent, UINT id)
{
	CString className = AfxRegisterWndClass(CS_HREDRAW | CS_VREDRAW | CS_OWNDC | CS_DBLCLKS, NULL, (HBRUSH)GetStockObject(BLACK_BRUSH), NULL);

	CWnd::CreateEx(0, className, "OpenGL", WS_CHILD | WS_VISIBLE | WS_CLIPSIBLINGS | WS_CLIPCHILDREN | WS_BORDER, rect, parent, id);
}

void CGLWnd::GLInitialize(void)
{
	static PIXELFORMATDESCRIPTOR pfd =
	{
		sizeof(PIXELFORMATDESCRIPTOR), 1, PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL | PFD_DOUBLEBUFFER, PFD_TYPE_RGBA, 32, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, };
	hdc = GetDC()->m_hDC;
	int nPixelFormat = ChoosePixelFormat(hdc, &pfd);
	SetPixelFormat(hdc, nPixelFormat, &pfd);
	hrc = wglCreateContext(hdc);
	wglMakeCurrent(hdc, hrc);


	HFONT	font;
	m_font_base = glGenLists(256);

	font = CreateFont(	12,							// Height Of Font
    0,								// Width Of Font
    0,								// Angle Of Escapement
    0,								// Orientation Angle
    0,						// Font Weight
    FALSE,							// Italic
    FALSE,							// Underline
    FALSE,							// Strikeout
    ANSI_CHARSET,					// Character Set Identifier
    OUT_TT_PRECIS,					// Output Precision
    CLIP_DEFAULT_PRECIS,			// Clipping Precision
    ANTIALIASED_QUALITY,			// Output Quality
    FF_DONTCARE|DEFAULT_PITCH,		// Family And Pitch
    "Verdana");				// Font Name

	SelectObject(hdc, font);

	wglUseFontOutlines(hdc,							// Select The Current DC
    0,								// Starting Character
    255,							// Number Of Display Lists To Build
    m_font_base,							// Starting Display Lists
    0.0f,							// Deviation From The True Outlines
    0.1f,							// Font Thickness In The Z Direction
    WGL_FONT_POLYGONS,				// Use Polygons, Not Lines
    gmf);							// Address Of Buffer To Recieve Data

}


void CGLWnd::on_idle()
{
  GLDrawScene(); 
}
