#pragma once

#include "OnIdle.h"
#include <boost/thread.hpp>

static inline float clamp(float x, float max, float min) 
{
  return x > max ? max : x < min ? min : x; 
}

static inline float clamp_pos(float x) 
{
  return clamp(x, x, 0.f);
}

static inline float clamp_neg(float x) 
{
  return clamp(x, 0.f, x);
}

struct vec2
{
  float x,y; 
  vec2(float _x, float _y) : x(_x), y(_y) {}; 
  vec2() : x(), y() {}; 

  vec2 operator + (const vec2& other) const 
  {
    vec2 result; 
    result.x = x + other.x; 
    result.y = y + other.y; 
    return result; 
  }

  vec2& operator += (const vec2& other)
  {
    x += other.x; 
    y += other.y; 
    return *this; 
  }

  vec2 operator - (const vec2& other) const 
  {
    vec2 result; 
    result.x = x - other.x; 
    result.y = y - other.y; 
    return result; 
  }

  vec2& operator -= (const vec2& other)
  {
    x -= other.x; 
    y -= other.y; 
    return *this; 
  }
};

struct clip_rect
{
  vec2 ul, br; 
  clip_rect() : ul(), br() {}; 
};

struct colour 
{ 
  float r,g,b; 

  colour() 
    : r(), 
      g(),
      b()
  {}

  colour(float _r, float _g, float _b) 
    : r(_r), 
      g(_g),
      b(_b)
  {}
}; 

#define RED colour(1.f, 0.0f, 0.0f)
#define GREEN colour(0.f, 1.0f, 0.0f)
#define BLUE colour(0.f, 0.0f, 1.0f)
#define WHITE colour(1.f, 1.0f, 1.0f)
#define BLACK	colour(0.0f, 0.0f, 0.0f)
#define Aquamarine		colour (0.439216f, 0.858824f, 0.576471f)
#define BlueViolet		colour (0.623529f, 0.372549f, 0.623529f)
#define Brown		colour (0.647059f, 0.164706f, 0.164706f)
#define CadetBlue		colour (0.372549f, 0.623529f, 0.623529f)
#define Coral		colour (1.0f, 0.498039f, 0.0f)
#define CornflowerBlue	colour (0.258824f, 0.258824f, 0.435294f)
#define Cyan		colour (0.0f, 1.0f, 1.0f)
#define DarkGray		colour (0.5f, 0.5f, 0.5f)
#define DarkGreen		colour (0.184314f, 0.309804f, 0.184314f)
#define DarkOliveGreen	colour (0.309804f, 0.309804f, 0.184314f)
#define DarkOrchild		colour (0.6f, 0.196078f, 0.8f)
#define DarkSlateBlue	colour (0.419608f, 0.137255f, 0.556863f)
#define DarkSlateGray	colour (0.184314f, 0.309804f, 0.309804f)
#define DarkSlateGrey	colour (0.184314f, 0.309804f, 0.309804f)
#define DarkTurquoise	colour (0.439216f, 0.576471f, 0.858824f)
#define DarkWood		colour (0.05f, 0.01f, 0.005f)
#define DimGray		colour (0.329412f, 0.329412f, 0.329412f)
#define DimGrey		colour (0.329412f, 0.329412f, 0.329412f)
#define FireBrick		colour (0.9f, 0.4f, 0.3f)
#define ForestGreen		colour (0.137255f, 0.556863f, 0.137255f)
#define Gold		colour (0.8f, 0.498039f, 0.196078f)
#define Goldenrod		colour (0.858824f, 0.858824f, 0.439216f)
#define Gray		colour (0.752941f, 0.752941f, 0.752941f)
#define Green		colour (0.0f, 1.0f, 0.0f)
#define GreenYellow		colour (0.576471f, 0.858824f, 0.439216f)
#define Grey		colour (0.752941f, 0.752941f, 0.752941f)
#define EndianRed		colour (0.309804f, 0.184314f, 0.184314f)
#define Khaki		colour (0.623529f, 0.623529f, 0.372549f)
#define LightBlue		colour (0.74902f, 0.847059f, 0.847059f)
#define LightGray		colour (0.658824f, 0.658824f, 0.658824f)
#define LightGrey		colour (0.658824f, 0.658824f, 0.658824f)
#define LightSteelBlue	colour (0.560784f, 0.560784f, 0.737255f)
#define LightWood		colour (0.6f, 0.24f, 0.1f)
#define LimeGreen		colour (0.196078f, 0.8f, 0.196078f)
#define Magenta		colour (1.0f, 0.0f, 1.0f)
#define Maroon		colour (0.556863f, 0.137255f, 0.419608f)
#define MedianWood		colour (0.3f, 0.12f, 0.03f)
#define MediumAquamarine	colour (0.196078f, 0.8f, 0.6f)
#define MediumBlue		colour (0.196078f, 0.196078f, 0.8f)
#define MediumForestGreen	colour (0.419608f, 0.556863f, 0.137255f)
#define MediumGoldenrod	colour (0.917647f, 0.917647f, 0.678431f)
#define MediumOrchid	colour (0.576471f, 0.439216f, 0.858824f)
#define MediumSeaGreen	colour (0.258824f, 0.435294f, 0.258824f)
#define MediumSlateBlue	colour (0.498039f, 0.0f, 1.0f)
#define MediumSpringGreen	colour (0.498039f, 1.0f, 0.0f)
#define MediumTurquoise	colour (0.439216f, 0.858824f, 0.858824f)
#define MediumVioletRed	colour (0.858824f, 0.439216f, 0.576471f)
#define MidnightBlue		colour (0.184314f, 0.184314f, 0.309804f)
#define Navy						colour (0.137255f, 0.137255f, 0.556863f)
#define NavyBlue				colour (0.137255f, 0.137255f, 0.556863f)
#define Orange					colour (0.8f, 0.196078f, 0.196078f)
#define OrangeRed				colour (0.0f, 0.0f, 0.498039f)
#define Orchid					colour (0.858824f, 0.439216f, 0.858824f)
#define PaleGreen				colour (0.560784f, 0.737255f, 0.560784f)
#define Pink						colour (0.737255f, 0.560784f, 0.560784f)
#define Plum						colour (0.917647f, 0.678431f, 0.917647f)
#define Red							colour (1.0f, 0.0f, 0.0f)
#define Salmon					colour (0.435294f, 0.258824f, 0.258824f)
#define SeaGreen				colour (0.137255f, 0.556863f, 0.419608f)
#define Sienna					colour (0.556863f, 0.419608f, 0.137255f)
#define SkyBlue					colour (0.196078f, 0.6f, 0.8f)
#define SlateBlue				colour (0.0f, 0.498039f, 1.0f)
#define SpringGreen			colour (0.0f, 1.0f, 0.498039f)
#define SteelBlue				colour (0.137255f, 0.419608f, 0.556863f)
#define Tan							colour (0.858824f, 0.576471f, 0.439216f)
#define Thistle					colour (0.847059f, 0.74902f, 0.847059f)
#define Transparent				colour (0.0f, 0.0f, 0.0f, 0.0f)
#define Turquoise				colour (0.678431f, 0.917647f, 0.917647f)
#define Violet					colour (0.309804f, 0.184314f, 0.309804f)
#define VioletRed				colour (0.8f, 0.196078f, 0.6f)
#define Wheat						colour (0.847059f, 0.847059f, 0.74902f)
#define Yellow					colour (1.0f, 1.0f, 0.0f)
#define YellowGreen			colour (0.6f, 0.8f, 0.196078f)

static const colour s_mod_colours[16] = {
  Aquamarine,
  BlueViolet,
  Brown,
  CadetBlue,
  Coral,
  CornflowerBlue,
  Cyan,
  DarkGray,
  DarkGreen,
  DarkOliveGreen,
  DarkOrchild,
  Sienna,
  DarkSlateGray,
  SkyBlue,
  VioletRed,
  DarkWood
}; 


class CGLWnd : public CWnd, protected idle_callback
{
	
public:

public:
	CGLWnd();
	virtual ~CGLWnd();

	virtual BOOL Create(LPCTSTR lpszClassName, LPCTSTR lpszWindowName, DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID, CCreateContext* pContext = NULL);
	virtual BOOL CreateEx(DWORD dwExStyle, LPCTSTR lpszClassName, LPCTSTR lpszWindowName, DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID, LPVOID lpParam = NULL);


public:

protected:
	// Added message classes:
	afx_msg void OnPaint();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg int  OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg BOOL OnMouseWheel(UINT nFlags, short zDelta, CPoint pt);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnMButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnMButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMouseLeave();

	DECLARE_MESSAGE_MAP()

private:

	void GLCreate(CRect rect, CWnd *parent, UINT id);
	void GLInitialize(void);
	void GLDrawScene(void);

  void on_idle();
  virtual void update_scene(); 

	HDC   hdc;			
	HGLRC hrc;			
  unsigned	m_font_base;
  GLYPHMETRICSFLOAT gmf[256];	

protected:

  boost::mutex m_mutex;

  void print(float x, float y, const colour& c, const char* fmt, ...);
  void print(float x, float y, float scale, const colour& c, const char* fmt, ...);
  void draw_line(const vec2& start, const vec2& end, const colour& c);
  void draw_box(const vec2& start, const vec2& end, const colour& c);

  vec2   m_transform; 
  float  m_scale; 
  clip_rect  m_clip; 
};
