//////////////////////////////////////////////////////////////////////////////
//
// Crytek Source File.
// Copyright (C), Crytek Studios, 2007.
// ---------------------------------------------------------------------------
// Description:
// mtrace server for recieving allocation information from cryengine3
// ps3 applications
// ---------------------------------------------------------------------------
// History:
// - June 13 2009 - Created by Christopher Raine 
//
//////////////////////////////////////////////////////////////////////////////

#include <mtracedb/mtracedb.h>
#include <time.h>
#include <list>
#include <iostream>
#include <boost/progress.hpp>

using mtracedb::cerr;
using mtracedb::out;

int mtracedb::filepump(
  mtracedb::file_reader_t& reader, 
  mtracedb::memory_monitor_t& monitor) 
{
  out(mtracedb::LOG_INFO) << "reading stream elements from filestream " << std::endl;

  boost::progress_display progress( 
    (unsigned long) reader.file_size() );

  mtracedb::memory_stream_element_t op; 
  while (reader.read(op)) 
  {
    monitor.process(op);
    progress += ((unsigned long)reader.current() - progress.count());
  }

  out(mtracedb::LOG_INFO) << std::endl; 

  return 0; 
}

