/*
 * This is the AT&T public domain implementation of getopt().  It is taken
 * from the c_count example program referenced from the 'UNIX Application
 * Migration Guide' (by Microsoft).
 *
 * Changes:
 * - Global names capitalized (i.e. getopt => Getopt, ...).
 * - Everything placed into a namespace 'Getopt'.
 * - 'const' qualifiers added.
 *
 * Sascha Demetrio <saschad@crytek.de>, 2006-11-14
 */

#include "Getopt.h"
using namespace Getopt;

// Original file: ////////////////////////////////////////////////////////////

/* ::[[ @(#) getopt.c 1.5 89/03/11 05:40:23 ]]:: */
#ifndef LINT
static const char Id[] = "$Id: getopt.c,v 1.2 2002/11/22 22:06:46 tom Exp $";
#endif

/*
 * Here's something you've all been waiting for:  the AT&T public domain
 * source for getopt(3).  It is the code which was given out at the 1985
 * UNIFORUM conference in Dallas.  I obtained it by electronic mail
 * directly from AT&T.  The people there assure me that it is indeed
 * in the public domain.
 *
 * There is no manual page.  That is because the one they gave out at
 * UNIFORUM was slightly different from the current System V Release 2
 * manual page.  The difference apparently involved a note about the
 * famous rules 5 and 6, recommending using white space between an option
 * and its first argument, and not grouping options that have arguments.
 * Getopt itself is currently lenient about both of these things White
 * space is allowed, but not mandatory, and the last option in a group can
 * have an argument.  That particular version of the man page evidently
 * has no official existence, and my source at AT&T did not send a copy.
 * The current SVR2 man page reflects the actual behavor of this getopt.
 * However, I am not about to post a copy of anything licensed by AT&T.
 */

#include <stdio.h>
#include <string.h>

#define ERR(szz, czz) \
        if (Opterr) \
        { \
                fprintf(stderr, "%s%s%c\n", Command ? Command : argv[0], szz, czz); \
        }

const char *Getopt::Command = NULL;
int Getopt::Opterr = 1;
int Getopt::Optind = 1;
int Getopt::Optopt;
const char *Getopt::Optarg;

int
Getopt::Getopt(int argc, const char *const *argv, const char *opts)
{
        static int sp = 1;
        register int c;
        register const char *cp;

        if (sp == 1) {
                if (Optind >= argc || argv[Optind][0] != '-' || argv[Optind][1] == '\0')
                        return (EOF);
                else if (strcmp(argv[Optind], "--") == 0) {
            Optind++;
            return (EOF);
                }
        }
        Optopt = c = argv[Optind][sp];
        if (c == ':' || (cp = strchr(opts, c)) == NULL) {
                ERR(": illegal option -- ", c);
                if (argv[Optind][++sp] == '\0') {
            Optind++;
            sp = 1;
                }
                return ('?');
        }
        if (*++cp == ':') {
                if (argv[Optind][sp + 1] != '\0')
                        Optarg = &argv[Optind++][sp + 1];
                else if (++Optind >= argc) {
            ERR(": option requires an argument -- ", c);
            sp = 1;
            return ('?');
                } else
            Optarg = argv[Optind++];
                sp = 1;
        } else {
                if (argv[Optind][++sp] == '\0') {
            sp = 1;
            Optind++;
                }
                Optarg = NULL;
        }
        return (c);
}

void Getopt::Reset()
{
  Optind = 1;
}

// vim:ts=2

// vim:expandtab

