/*
 * This is the AT&T public domain implementation of getopt().  It is taken
 * from the c_count example program referenced from the 'UNIX Application
 * Migration Guide' (by Microsoft).
 *
 * Changes:
 * - Global names capitalized (i.e. getopt => Getopt, ...).
 * - Everything placed into a namespace 'Getopt'.
 * - Added declaration for 'Optopt'.
 * - 'const' qualifiers added.
 * - Include guards added.
 *
 * Sascha Demetrio <saschad@crytek.de>, 2006-11-14
 */

#if !defined __Getopt_h__
#define __Getopt_h__

namespace Getopt
{
  extern const char *Command;
  extern const char *Optarg;
  extern int Optind, Opterr, Optopt;

  int Getopt(int argc, const char *const *argv, const char *options);

  void Reset();
}

#endif

// vim:expandtab

