#include "stdafx.h"
#include "Nodes/G2FlowBaseNode.h"

#include "Browser/WebKitHud.h"

#define DEFAULT_URL string( "file:///" )

#define PORT_TRIGGER_SHOW 0
#define PORT_TRIGGER_HIDE 1

#define PORT_URL 2

#define PORT_TRIGGER_ENABLE_INPUT  3
#define PORT_TRIGGER_DISABLE_INPUT 4

#define PORT_TRIGGER_ENABLE_TRANSPARENT 5
#define PORT_TRIGGER_DISABLE_TRANSPARENT 6

class CFlowNode_BrowserHud
	: public CFlowBaseNode
{
public:
	CFlowNode_BrowserHud( SActivationInfo* pActivationInfo )
	{
	}

	virtual IFlowNodePtr Clone( SActivationInfo* pActivationInfo )
	{
		return new CFlowNode_BrowserHud( pActivationInfo );
	}

	void Serialize( SActivationInfo*, TSerialize ser )
	{
	}

	virtual void GetConfiguration( SFlowNodeConfig& config )
	{
		static const SInputPortConfig inputPortsConfig[] =
		{
			InputPortConfig_Void( "Show", _HELP( "Trigger this port to show the HUD" ) ),
			InputPortConfig_Void( "Hide", _HELP( "Trigger this port to hide the HUD" ) ),
			InputPortConfig< string >( "URL", DEFAULT_URL, _HELP( "Start URL for the HUD" ) ),
			InputPortConfig_Void( "Enable Input", _HELP( "Trigger this port to enable input for the HUD" ) ),
			InputPortConfig_Void( "Disable Input", _HELP( "Trigger this port to disable input for the HUD" ) ),
			InputPortConfig_Void( "Transparent", _HELP( "Trigger this port to enable transparency for the HUD" ) ),
			InputPortConfig_Void( "Opaque", _HELP( "Trigger this port to disable transparency for the HUD" ) ),
			{ 0	}
		};

		config.sDescription = _HELP( "Web HUD" );
		config.pInputPorts = inputPortsConfig;
		config.pOutputPorts = 0;
		config.SetCategory( EFLN_APPROVED );
	}

	virtual void ProcessEvent( EFlowEvent event, SActivationInfo* pActivationInfo )
	{
		CWebKitHud* pWebKitHud = CWebKitHud::GetInstance();
		if ( pWebKitHud == NULL )
		{
			return;
		}

		if ( event != eFE_Activate )
		{
			return;
		}

		if ( IsPortActive( pActivationInfo, PORT_TRIGGER_SHOW ) )
		{
			const char* url = GetUrl( pActivationInfo ).c_str();
			pWebKitHud->LoadURL( url );
			pWebKitHud->Show();
		}
		
		if ( IsPortActive( pActivationInfo, PORT_TRIGGER_HIDE ) )
		{
			pWebKitHud->Hide();
		}

		if ( IsPortActive( pActivationInfo, PORT_TRIGGER_ENABLE_INPUT ) )
		{
			if ( ! pWebKitHud->IsHudInputEnabled() )
			{
				pWebKitHud->SetHudInputEnabled( true );
				pWebKitHud->SetPlayerInputEnabled( false );
				pWebKitHud->SetCursorVisible( true );
			}
		}

		if ( IsPortActive( pActivationInfo, PORT_TRIGGER_DISABLE_INPUT ) )
		{
			if ( pWebKitHud->IsHudInputEnabled() )
			{
				pWebKitHud->SetHudInputEnabled( false );
				pWebKitHud->SetPlayerInputEnabled( true );
				pWebKitHud->SetCursorVisible( false );
			}
		}

		if ( IsPortActive( pActivationInfo, PORT_TRIGGER_ENABLE_TRANSPARENT ) )
		{
			pWebKitHud->SetTransparent( true );
		}
		
		if ( IsPortActive( pActivationInfo, PORT_TRIGGER_DISABLE_TRANSPARENT ) )
		{
			pWebKitHud->SetTransparent( false );
		}
	}

	virtual void GetMemoryStatistics( ICrySizer* s )
	{
		s->Add( *this );
	}

	const string& GetUrl( SActivationInfo* pActivationInfo ) const
	{
		return GetPortString( pActivationInfo, PORT_URL );
	}

};

REGISTER_FLOW_NODE( "HUD:BrowserHud", CFlowNode_BrowserHud );
