#include "stdafx.h"
#include "Nodes/G2FlowBaseNode.h"

#include "Browser/WebKitHud.h"


#define PORT_TRIGGER 0
#define PORT_NAME 1
#define PORT_VALUE 2
#define PORT_REFRESH 3

template < typename T >
class CFlowNode_BrowserHudProperty
	: public CFlowBaseNode
{
public:
	CFlowNode_BrowserHudProperty( SActivationInfo* pActivationInfo )
	{
	}

	virtual IFlowNodePtr Clone( SActivationInfo* pActivationInfo )
	{
		return new CFlowNode_BrowserHudProperty< T >( pActivationInfo );
	}

	void Serialize( SActivationInfo*, TSerialize ser )
	{
	}

	virtual void GetConfiguration( SFlowNodeConfig& config )
	{
		static const SInputPortConfig inputPortsConfig[] =
		{
			InputPortConfig_Void( "Trigger", _HELP( "Send the property value to the BrowserHud" ) ),
			InputPortConfig< string >( "Name", _HELP( "Name of the property" ) ),
			InputPortConfig< T >( "Value", _HELP( "Value of the property" ) ),
			InputPortConfig< bool >( "Refresh", true, _HELP( "Refresh the HUD after setting the property?" ) ),
			{ 0	}
		};

		config.sDescription = _HELP( "Web HUD Property" );
		config.pInputPorts = inputPortsConfig;
		config.pOutputPorts = 0;
		config.SetCategory( EFLN_APPROVED );
	}

	virtual void ProcessEvent( EFlowEvent event, SActivationInfo* pActivationInfo )
	{
		CWebKitHud* pWebKitHud = CWebKitHud::GetInstance();
		if ( pWebKitHud == NULL )
		{
			return;
		}

		if ( event != eFE_Activate )
		{
			return;
		}

		if ( IsPortActive( pActivationInfo, PORT_TRIGGER ) )
		{
			const string& name = GetName( pActivationInfo );
			const T& value = GetValue( pActivationInfo );
			bool refresh = GetRefresh( pActivationInfo );
			
			pWebKitHud->SetProperty( name, value );

			if ( refresh )
			{
				pWebKitHud->Refresh();
			}
		}
	}

	virtual void GetMemoryStatistics( ICrySizer* s )
	{
		s->Add( *this );
	}

	const string& GetName( SActivationInfo* pActivationInfo ) const
	{
		return GetPortString( pActivationInfo, PORT_NAME );
	}

	const T& GetValue( SActivationInfo* pActivationInfo )
	{
		static T s_value;

		const TFlowInputData& data = GetPortAny( pActivationInfo, PORT_VALUE );
		data.GetValueWithConversion( s_value );

		return s_value;
	}

	bool GetRefresh( SActivationInfo* pActivationInfo )
	{
		return GetPortBool( pActivationInfo, PORT_REFRESH );
	}

};

typedef CFlowNode_BrowserHudProperty< string > CFlowNode_BrowserHudPropertyString;
typedef CFlowNode_BrowserHudProperty< float > CFlowNode_BrowserHudPropertyFloat;
typedef CFlowNode_BrowserHudProperty< int > CFlowNode_BrowserHudPropertyInt;
typedef CFlowNode_BrowserHudProperty< bool > CFlowNode_BrowserHudPropertyBool;

REGISTER_FLOW_NODE( "HUD:BrowserHudPropertyString", CFlowNode_BrowserHudPropertyString );
REGISTER_FLOW_NODE( "HUD:BrowserHudPropertyInt", CFlowNode_BrowserHudPropertyInt );
REGISTER_FLOW_NODE( "HUD:BrowserHudPropertyFloat", CFlowNode_BrowserHudPropertyFloat );
REGISTER_FLOW_NODE( "HUD:BrowserHudPropertyBool", CFlowNode_BrowserHudPropertyBool );
