#include "stdafx.h"
#include "Nodes/G2FlowBaseNode.h"

#include "WebKitHud.h"

#include "IJavascriptCallbackListener.h"

#define PORT_IN_NAME 0
#define PORT_IN_ENABLED 1

#define PORT_OUT_TRIGGER 0

#define CALLBACK_NAME "Trigger"

class CFlowNode_BrowserHudTrigger
	: public CFlowBaseNode
	, IJavascriptCallbackListener
{
public:
	CFlowNode_BrowserHudTrigger( SActivationInfo* pActivationInfo )
	{
		RegisterAsTriggerListener();
	}

	virtual ~CFlowNode_BrowserHudTrigger()
	{
		UnRegisterAsTriggerListener();
	}

	void RegisterAsTriggerListener()
	{
		CWebKitHud* pWebKitHud = CWebKitHud::GetInstance();
		if ( pWebKitHud == NULL )
		{
			return;
		}

		pWebKitHud->RegisterCallbackName( CALLBACK_NAME );
		pWebKitHud->AddJavascriptListener( this );
	}

	void UnRegisterAsTriggerListener()
	{
		CWebKitHud* pWebKitHud = CWebKitHud::GetInstance();
		if ( pWebKitHud == NULL )
		{
			return;
		}

		pWebKitHud->RemoveJavascriptListener( this );
	}

	virtual IFlowNodePtr Clone( SActivationInfo* pActivationInfo )
	{
		return new CFlowNode_BrowserHudTrigger( pActivationInfo );
	}

	void Serialize( SActivationInfo*, TSerialize ser )
	{
	}

	virtual void OnJavascriptCallback( const char* callbackName, const CJavascriptArguments& arguments )
	{
		bool enabled = GetEnabled();
		if ( ! enabled )
		{
			return;
		}

		bool isTriggerCallback = ( strcmp( callbackName, CALLBACK_NAME ) == 0 );
		if ( ! isTriggerCallback )
		{
			return;
		}

		if ( arguments.GetCount() != 1 )
		{
			return;
		}

		CJavascriptValueProxy triggerNameJs;
		arguments.GetArgument( 0, &triggerNameJs );
		const char* activatedTriggerName = triggerNameJs.GetStringValue();

		const char* listenedTriggerName = GetListenedTriggerName().c_str();
		
		bool listenedTriggerActivated = ( strcmp( listenedTriggerName, activatedTriggerName ) == 0 );
		if ( ! listenedTriggerActivated )
		{
			return;
		}

		ActivateTrigger();
	}

	void ActivateTrigger()
	{
		ActivateOutput( &m_activationInfo, PORT_OUT_TRIGGER, true );
	}

	virtual void GetConfiguration( SFlowNodeConfig& config )
	{
		static const SInputPortConfig inputPortsConfig[] =
		{
			InputPortConfig< string >( "Name", _HELP( "Name of the trigger to listen to." ) ),
			InputPortConfig< bool >( "Enabled", true, _HELP( "" ) ),
			{ 0	}
		};

		static const SOutputPortConfig outputPortsConfig[] =
		{
			OutputPortConfig_Void( "Trigger", _HELP( "Triggered from javascript when a 'Client." CALLBACK_NAME "( name )' event is sent that matches the node name." ) ),
			{ 0	}
		};

		config.sDescription = _HELP( "Web HUD" );
		config.pInputPorts = inputPortsConfig;
		config.pOutputPorts = outputPortsConfig;
		config.SetCategory( EFLN_APPROVED );
	}

 	virtual void ProcessEvent( EFlowEvent event, SActivationInfo* pActivationInfo )
 	{
		if ( event == eFE_Initialize )
		{
			m_activationInfo = *pActivationInfo;
		}
	}

	virtual void GetMemoryStatistics( ICrySizer* s )
	{
		s->Add( *this );
	}

	const string& GetListenedTriggerName()
	{
		return GetPortString( &m_activationInfo, PORT_IN_NAME );
	}

	bool GetEnabled()
	{
		return GetPortBool( &m_activationInfo, PORT_IN_ENABLED );
	}

protected:
	SActivationInfo m_activationInfo;

};

REGISTER_FLOW_NODE( "HUD:BrowserHudTrigger", CFlowNode_BrowserHudTrigger );
