#ifndef __Webkit_Hud__h__
#define __Webkit_Hud__h__
#pragma once

#include "ConfigBrowserWindow.h"

#ifdef BROWSER_GUI_ENABLED

#include "IHardwareMouse.h"
#include "IGameFramework.h"
#include "IInput.h"
#include "ILevelSystem.h"

#include "IJavascriptCallbackListener.h"

#include "WebKitTexture.h"
#include "WebKitHudJsCallbacks.h"
#include "WebKitHudConfig.h"

class CWebCoreProxy;
class CWebViewProxy;

class CWebKitHud
	: public IHardwareMouseEventListener
	, public IGameFrameworkListener
	, public ILevelSystemListener
{
public:
	virtual ~CWebKitHud();

	static void Init();
	static void ShutDown();
	static CWebKitHud* GetInstance();

	bool IsVisible() const;
	void SetVisible( bool visible );
	void ToggleVisible();
	void Show();
	void Hide();

	void SetTransparent( bool transparent );
	bool IsTransparent() const;

	void SetHudInputEnabled( bool hudInputEnabled );
	bool IsHudInputEnabled() const;

	void SetCursorVisible( bool cursorVisible );
	bool IsCursorVisible() const;
	
	void SetPlayerInputEnabled( bool playerInputEnabled );

	// InputInjection
	void InjectKeyboardKeyUp( UINT_PTR wParam, LONG_PTR lParam );
	void InjectKeyboardKeyDown( UINT_PTR wParam, LONG_PTR lParam );
	void InjectKeyboardChar( UINT_PTR wParam, LONG_PTR lParam );
	// ~InputInjection

	// IHardwareMouseEventListener
	virtual void OnHardwareMouseEvent( int mouseX, int mouseY, EHARDWAREMOUSEEVENT hardwareMouseEvent, int wheelDelta );
	// ~IHardwareMouseEventListener

	// WebBrowser
	void LoadURL( const string url );
	void LoadBlankPage();
	void Refresh();
	// ~WebBrowser

	// JavascriptBrowser
	void SetProperty( const string& name, const string& value );
	void SetProperty( const string& name, float value );
	void SetProperty( const string& name, int value );
	void SetProperty( const string& name, bool value );

	void RegisterCallbackName( const string& callbackName );
	void AddJavascriptListener( IJavascriptCallbackListener* listener );
	void RemoveJavascriptListener( IJavascriptCallbackListener* listener );
	// ~JavascriptBrowser

	// IGameFrameworkListener
	virtual void OnPostUpdate( float deltaTime );
	virtual void OnSaveGame( ISaveGame* pSaveGame ) {}
	virtual void OnLoadGame( ILoadGame* pLoadGame ) {}
	virtual void OnLevelEnd( const char* nextLevel ) {}
	virtual void OnActionEvent( const SActionEvent& event ) {}
	// ~IGameFrameworkListener

	// ILevelSystemListener
	virtual void OnLevelNotFound( const char* levelName );
	virtual void OnLoadingStart( ILevelInfo* pLevel );
	virtual void OnLoadingComplete( ILevel* pLevel );
	virtual void OnLoadingError( ILevelInfo* pLevel, const char* error );
	virtual void OnLoadingProgress( ILevelInfo* pLevel, int progressAmount );
	// ~ILevelSystemListener

protected:
	bool CanInjectInput() const;

	void Render();
	void RenderLoading();

	CWebCoreProxy* GetWebCore();
	const CWebCoreProxy* GetWebCore() const;

	CWebViewProxy* GetWebView();
	const CWebViewProxy* GetWebView() const;

	void UpdateLoadingProgress( ILevelInfo* pLevel, int progressAmount );

	void SetStartStateProperties();
	void SetLoadingStateProperties();
	void SetGameStateProperties();

private:
	CWebKitHud();
	CWebKitHud( const CWebKitHud& ) {}
	void operator = ( const CWebKitHud& ) {}

private:
	static CWebKitHud* ms_instance;

	IRenderer* m_pRenderer;

	CWebCoreProxy* m_pWebCore;
	CWebViewProxy* m_pWebView;

	bool m_visible;
	bool m_transparent;

	bool m_hudInputEnabled;
	bool m_cursorVisible;

	CWebKitTexture m_webKitTexture;

	CWebKitHudJsCallbacks m_webKitCallbacks;

	CWebKitHudConfig m_webKitConfig;

	bool m_loadingMap;
};

#endif //BROWSER_GUI_ENABLED

#endif //__Webkit_Hud__h__
