#include "StdAfx.h"
#include "WebKitHudJsCallbacks.h"

#include "WebViewProxy.h"

#define CONSOLE_CALLBACK_NAME "Console"
#define CVAR_CALLBACK_NAME "CVar"
#define LOAD_MAP_CALLBACK_NAME "LoadMap"

/************************************************************************/
CWebKitHudJsCallbacks::CWebKitHudJsCallbacks()
: m_pWebView( NULL )
{

}

/************************************************************************/
CWebKitHudJsCallbacks::~CWebKitHudJsCallbacks()
{
}

/************************************************************************/
void CWebKitHudJsCallbacks::Init( CWebViewProxy* pWebView )
{
	m_pWebView = pWebView;
	m_pWebView->AddJavascriptListener( this );

	RegisterJavascriptCallback( CVAR_CALLBACK_NAME, functor( *this, &CWebKitHudJsCallbacks::OnCVarCallback ) );
	RegisterJavascriptCallback( CONSOLE_CALLBACK_NAME, functor( *this, &CWebKitHudJsCallbacks::OnConsoleCallback ) );
	RegisterJavascriptCallback( LOAD_MAP_CALLBACK_NAME, functor( *this, &CWebKitHudJsCallbacks::OnLoadMapCallback ) );
}

/************************************************************************/
void CWebKitHudJsCallbacks::OnJavascriptCallback( const char* callbackName, const CJavascriptArguments& arguments )
{
	if ( callbackName == NULL )
	{
		return;
	}

	JavascriptHudCallbackMap::const_iterator cit = m_javascriptHudCallbacks.find( string( callbackName ) );
	bool callbackFunctionFound = ( cit != m_javascriptHudCallbacks.end() );

	if ( ! callbackFunctionFound )
	{
		return;
	}

	const JavascriptHudCallback& commandFunction = cit->second;
	commandFunction( arguments );
}


/************************************************************************/
void CWebKitHudJsCallbacks::RegisterJavascriptCallback( const string& callbackName, const JavascriptHudCallback& callbackFunction )
{
	if ( ! callbackFunction )
	{
		return;
	}

	m_javascriptHudCallbacks[ callbackName ] = callbackFunction;
	m_pWebView->RegisterCallback( callbackName.c_str() );
}


/************************************************************************/
void CWebKitHudJsCallbacks::OnCVarCallback( const CJavascriptArguments& arguments )
{
	if ( arguments.GetCount() != 2 )
	{
		return;
	}

	CJavascriptValueProxy cVarNameJs;
	arguments.GetArgument( 0, &cVarNameJs );
	const char* cVarName = cVarNameJs.GetStringValue();

	CJavascriptValueProxy cVarValueJs;
	arguments.GetArgument( 1, &cVarValueJs );
	const char* cVarValue = cVarValueJs.GetStringValue();

	ICVar* cVar = gEnv->pConsole->GetCVar( cVarName );

	if ( cVar == NULL )
	{
		return;
	}

	cVar->Set( cVarValue );
}

/************************************************************************/
void CWebKitHudJsCallbacks::OnConsoleCallback( const CJavascriptArguments& arguments )
{
	if ( arguments.GetCount() != 1 )
	{
		return;
	}

	CJavascriptValueProxy consoleCommandJs;
	arguments.GetArgument( 0, &consoleCommandJs );
	const char* consoleCommand = consoleCommandJs.GetStringValue();

	ExecuteDeferredConsoleCommand( consoleCommand );
}

/************************************************************************/
void CWebKitHudJsCallbacks::OnLoadMapCallback( const CJavascriptArguments& arguments )
{
	if ( arguments.GetCount() != 1 )
	{
		return;
	}

	CJavascriptValueProxy mapNameJS;
	arguments.GetArgument( 0, &mapNameJS );
	const char* mapName = mapNameJS.GetStringValue();

	string mapCommand = string( "map " ) + string( mapName );

	ExecuteDeferredConsoleCommand( mapCommand );
}

/************************************************************************/
void CWebKitHudJsCallbacks::ExecuteDeferredConsoleCommand( const string& consoleCommand )
{
	gEnv->pConsole->ExecuteString( consoleCommand, false, true );
}
