#ifndef __WebKitHudJsCallbacks__h__
#define __WebKitHudJsCallbacks__h__
#pragma once

#include "IJavascriptCallbackListener.h"

class CWebViewProxy;

class CWebKitHudJsCallbacks
	: public IJavascriptCallbackListener 
{
public:
	CWebKitHudJsCallbacks();
	virtual ~CWebKitHudJsCallbacks();

	void Init( CWebViewProxy* pWebView );

	// IJavascriptCallbackListener
	virtual void OnJavascriptCallback( const char* callbackName, const CJavascriptArguments& arguments );
	// ~IJavascriptCallbackListener

protected:
	typedef Functor1< const CJavascriptArguments& > JavascriptHudCallback;
	void RegisterJavascriptCallback( const string& callbackName, const JavascriptHudCallback& callbackFunction );

	void OnCVarCallback( const CJavascriptArguments& arguments );
	void OnConsoleCallback( const CJavascriptArguments& arguments );
	void OnLoadMapCallback( const CJavascriptArguments& arguments );

	void ExecuteDeferredConsoleCommand( const string& consoleCommand );

private:
	typedef std::map< string, JavascriptHudCallback > JavascriptHudCallbackMap;
	JavascriptHudCallbackMap m_javascriptHudCallbacks;

	CWebViewProxy* m_pWebView;
};

#endif


