#ifndef __WebKitTextureHelper__h__
#define __WebKitTextureHelper__h__
#pragma once

class CWebViewProxy;

class CWebKitTexture
{
public:
	CWebKitTexture();
	virtual ~CWebKitTexture();

	void RenderToFillViewport( CWebViewProxy* pWebView, bool transparent );

	int GetWidth() const;
	int GetHeight() const;

protected:
 	int GetTextureId() const;

 	void CreateTexture( int textureWidth, int textureHeight );
 
 	void UpdateTextureContents( CWebViewProxy* pWebView );
 
 	void UpdateStoredViewportSize();
 	int GetViewportWidth() const;
 	int GetViewportHeight() const;

private:
	IRenderer* m_pRenderer;
	ITexture* m_pTexture;
	int m_viewportWidth;
	int m_viewportHeight;
};

#endif