/*************************************************************************
  Crytek Source File.
  Copyright (C), Crytek Studios, 2001-2004.
 -------------------------------------------------------------------------
  $Id$
  $DateTime$
  
 -------------------------------------------------------------------------
  History:
  - 11:8:2004   10:50 : Created by Mrcio Martins

*************************************************************************/
#include "StdAfx.h"
#include "GameCVars.h"
#include "GameRules.h"
#include "ItemSharedParams.h"

#include <INetwork.h>
#include <IGameObject.h>
#include <IActorSystem.h>
#include <IItemSystem.h>
#include "ServerSynchedStorage.h"
#include "ItemString.h"
#include "Environment/BattleDust.h"
#include "NetInputChainDebug.h"

#include "INetworkService.h"

#include <IPathfinder.h>

#include "Boids/Flock.h"

#include "Player.h"
#include "IVehicleSystem.h"
#include <ILevelSystem.h>

static void BroadcastChangeSafeMode( ICVar * )
{
	SGameObjectEvent event(eCGE_ResetMovementController, eGOEF_ToExtensions);
	IEntitySystem * pES = gEnv->pEntitySystem;
	IEntityItPtr pIt = pES->GetEntityIterator();
	while (!pIt->IsEnd())
	{
		if (IEntity * pEnt = pIt->Next())
			if (IActor * pActor = g_pGame->GetIGameFramework()->GetIActorSystem()->GetActor(pEnt->GetId()))
				pActor->HandleEvent( event );
	}
}

void CmdBulletTimeMode( IConsoleCmdArgs* cmdArgs)
{
	g_pGameCVars->goc_enable = 0;
	g_pGameCVars->goc_tpcrosshair = 0;

	g_pGameCVars->bt_ironsight = 1;
	g_pGameCVars->bt_speed = 0;
	g_pGameCVars->bt_energy_decay = 2.5;
	g_pGameCVars->bt_end_reload = 1;
	g_pGameCVars->bt_end_select = 1;
	g_pGameCVars->bt_end_melee = 0;
}

void CmdGOCMode( IConsoleCmdArgs* cmdArgs)
{
	g_pGameCVars->goc_enable = 1;
	g_pGameCVars->goc_tpcrosshair = 1;
	
	g_pGameCVars->bt_ironsight = 1;
	g_pGameCVars->bt_speed = 0;
	g_pGameCVars->bt_energy_decay = 0;
	g_pGameCVars->bt_end_reload = 1;
	g_pGameCVars->bt_end_select = 1;
	g_pGameCVars->bt_end_melee = 0;
	g_pGameCVars->g_enableAlternateIronSight = 1;

	//
	CPlayer *pPlayer = static_cast<CPlayer *>(gEnv->pGame->GetIGameFramework()->GetClientActor());
	if(pPlayer && !pPlayer->IsThirdPerson())
	{
		pPlayer->ToggleThirdPerson();
	}
}

// game related cvars must start with an g_
// game server related cvars must start with sv_
// game client related cvars must start with cl_
// no other types of cvars are allowed to be defined here!
void SCVars::InitCVars(IConsole *pConsole)
{
	//client cvars
	//REGISTER_CVAR(cl_hud,1,0,"Show/Hide the HUD")->SetOnChangeCallback(CHUDCommon::HUD);
	REGISTER_CVAR(cl_fov, 60.0f, 0, "field of view.");
	REGISTER_CVAR(cl_bob, 1.0f, 0, "view/weapon bobbing multiplier");
	REGISTER_CVAR(cl_headBob, 1.0f, 0, "head bobbing multiplier");
	REGISTER_CVAR(cl_headBobLimit, 0.06f, 0, "head bobbing distance limit");
	REGISTER_CVAR(cl_tpvDist, 3.5f, 0, "camera distance in 3rd person view");
	REGISTER_CVAR(cl_tpvYaw, 0, 0, "camera angle offset in 3rd person view");
	REGISTER_CVAR(cl_nearPlane, 0, 0, "overrides the near clipping plane if != 0, just for testing.");
	REGISTER_CVAR(cl_sprintShake, 0.0f, 0, "sprint shake");
	REGISTER_CVAR(cl_sensitivityZeroG, 70.0f, VF_DUMPTODISK, "Set mouse sensitivity in ZeroG!");
	REGISTER_CVAR(cl_sensitivity, 45.0f, VF_DUMPTODISK, "Set mouse sensitivity!");
	REGISTER_CVAR(cl_invertMouse, 0, VF_DUMPTODISK, "mouse invert?");
	REGISTER_CVAR(cl_invertController, 0, VF_DUMPTODISK, "Controller Look Up-Down invert");
	REGISTER_CVAR(cl_crouchToggle, 0, VF_DUMPTODISK, "To make the crouch key work as a toggle");
	REGISTER_CVAR(cl_fpBody, 2, 0, "first person body");
	//FIXME:just for testing
	REGISTER_CVAR(cl_strengthscale, 1.0f, 0, "nanosuit strength scale");

	REGISTER_CVAR(cl_camModify, 0, 0, "Enable camera modifiers.");
	REGISTER_CVAR(cl_camKeepX, 1.0f, 0, "Fraction of camera x-axis rotation to keep.");
	REGISTER_CVAR(cl_camKeepY, 1.0f, 0, "Fraction of camera y-axis rotation to keep.");
	REGISTER_CVAR(cl_camKeepZ, 1.0f, 0, "Fraction of camera z-axis rotation to keep.");
	REGISTER_CVAR(cl_camOffsetX, 0.0f, 0, "Degrees to offset camera around x-axis.");
	REGISTER_CVAR(cl_camOffsetY, 0.0f, 0, "Degrees to offset camera around y-axis.");
	REGISTER_CVAR(cl_camOffsetZ, 0.0f, 0, "Degrees to offset camera around z-axis.");
	REGISTER_CVAR(cl_camRotateX, 0.0f, 0, "Degrees to rotate camera per second around x-axis.");
	REGISTER_CVAR(cl_camRotateY, 0.0f, 0, "Degrees to rotate camera per second around y-axis.");
	REGISTER_CVAR(cl_camRotateZ, 0.0f, 0, "Degrees to rotate camera per second around z-axis.");
	REGISTER_CVAR(cl_camTranslateX, 0.0f, 0, "Translate along camera local x-axis.");
	REGISTER_CVAR(cl_camTranslateY, 0.0f, 0, "Translate along camera local y-axis.");
	REGISTER_CVAR(cl_camTranslateZ, 0.0f, 0, "Translate along camera local z-axis.");

	// GOC
	REGISTER_CVAR(goc_enable, 0, VF_CHEAT, "gears of crysis");
	REGISTER_CVAR(goc_tpcrosshair, 0, VF_CHEAT, "keep crosshair in third person");
	REGISTER_CVAR(goc_targetx, 0.5f, VF_CHEAT, "target position of camera");
	REGISTER_CVAR(goc_targety, -2.5f, VF_CHEAT, "target position of camera");
	REGISTER_CVAR(goc_targetz, 0.2f, VF_CHEAT, "target position of camera");
	REGISTER_COMMAND("GOCMode", CmdGOCMode, VF_CHEAT, "Enable GOC mode");
	
	// BulletTime
	REGISTER_CVAR(bt_ironsight, 0, VF_CHEAT, "bullet-time when in ironsight");
	REGISTER_CVAR(bt_speed, 0, VF_CHEAT, "bullet-time when in speed mode");
	REGISTER_CVAR(bt_end_reload, 0, VF_CHEAT, "end bullet-time when reloading");
	REGISTER_CVAR(bt_end_select, 0, VF_CHEAT, "end bullet-time when selecting a new weapon");
	REGISTER_CVAR(bt_end_melee, 0, VF_CHEAT, "end bullet-time when melee");
	REGISTER_CVAR(bt_time_scale, 0.2f, VF_CHEAT, "bullet-time time scale to apply");
	REGISTER_CVAR(bt_pitch, -0.4f, VF_CHEAT, "sound pitch shift for bullet-time");
	REGISTER_CVAR(bt_energy_max, 1.0f, VF_CHEAT, "maximum bullet-time energy");
	REGISTER_CVAR(bt_energy_decay, 2.5f, VF_CHEAT, "bullet time energy decay rate");
	REGISTER_CVAR(bt_energy_regen, 0.5f, VF_CHEAT, "bullet time energy regeneration rate");
	REGISTER_COMMAND("bulletTimeMode", CmdBulletTimeMode, VF_CHEAT, "Enable bullet time mode");

	REGISTER_CVAR(dt_enable, 0, 0, "suit actions activated by double-tapping");
	REGISTER_CVAR(dt_time, 0.25f, 0, "time in seconds between double taps");
	REGISTER_CVAR(dt_meleeTime, 0.3f, 0, "time in seconds between double taps for melee");

	REGISTER_CVAR(i_staticfiresounds, 1, VF_DUMPTODISK, "Enable/Disable static fire sounds. Static sounds are not unloaded when idle.");
	REGISTER_CVAR(i_soundeffects,	1, VF_DUMPTODISK, "Enable/Disable playing item sound effects.");
	REGISTER_CVAR(i_lighteffects, 1, VF_DUMPTODISK, "Enable/Disable lights spawned during item effects.");
	REGISTER_CVAR(i_particleeffects,	1, VF_DUMPTODISK, "Enable/Disable particles spawned during item effects.");
	REGISTER_CVAR(i_rejecteffects, 1, VF_DUMPTODISK, "Enable/Disable ammo reject effects during weapon firing.");
	REGISTER_CVAR(i_offset_front, 0.0f, 0, "Item position front offset");
	REGISTER_CVAR(i_offset_up, 0.0f, 0, "Item position up offset");
	REGISTER_CVAR(i_offset_right, 0.0f, 0, "Item position right offset");
	REGISTER_CVAR(i_unlimitedammo, 0, VF_CHEAT, "unlimited ammo");
	REGISTER_CVAR(i_iceeffects, 0, VF_CHEAT, "Enable/Disable specific weapon effects for ice environments");

	// marcok TODO: seem to be only used on script side ... 
	REGISTER_FLOAT("cl_motionBlur", 2, 0, "motion blur type (0=off, 1=accumulation-based, 2=velocity-based)");
	REGISTER_FLOAT("cl_sprintBlur", 0.6f, 0, "sprint blur");
	REGISTER_FLOAT("cl_hitShake", 1.25f, 0, "hit shake");
	REGISTER_FLOAT("cl_hitBlur", 0.25f, 0, "blur on hit");

	REGISTER_INT("cl_righthand", 1, 0, "Select right-handed weapon!");
	REGISTER_INT("cl_screeneffects", 1, 0, "Enable player screen effects (depth-of-field, motion blur, ...).");
	
	REGISTER_CVAR(cl_debugSwimming, 0, VF_CHEAT, "enable swimming debugging");

	ca_GameControlledStrafingPtr = pConsole->GetCVar("ca_GameControlledStrafing");
	REGISTER_CVAR(pl_curvingSlowdownSpeedScale, 0.5f, VF_CHEAT, "Player only slowdown speedscale when curving/leaning extremely.");
	REGISTER_CVAR(ac_enableProceduralLeaning, 1.0f, VF_CHEAT, "Enable procedural leaning (disabled asset leaning and curving slowdown).");

	REGISTER_CVAR(cl_shallowWaterSpeedMulPlayer, 0.6f, VF_CHEAT, "shallow water speed multiplier (Players only)");
	REGISTER_CVAR(cl_shallowWaterSpeedMulAI, 0.8f, VF_CHEAT, "Shallow water speed multiplier (AI only)");
	REGISTER_CVAR(cl_shallowWaterDepthLo, 0.3f, VF_CHEAT, "Shallow water depth low (below has zero slowdown)");
	REGISTER_CVAR(cl_shallowWaterDepthHi, 1.0f, VF_CHEAT, "Shallow water depth high (above has full slowdown)");

	REGISTER_INT("g_grabLog", 0, 0, "verbosity for grab logging (0-2)");

	REGISTER_CVAR(pl_inputAccel, 30.0f, 0, "Movement input acceleration");

	REGISTER_INT("cl_actorsafemode", 0, VF_CHEAT, "Enable/disable actor safe mode")->SetOnChangeCallback(BroadcastChangeSafeMode);
	REGISTER_CVAR(h_useIK, 1, 0, "Hunter uses always IK");
	REGISTER_CVAR(h_drawSlippers, 0, 0, "Red ball when tentacle is lifted, green when on ground");
	REGISTER_CVAR(g_tentacle_joint_limit, -1.0f, 0, "forces specific tentacle limits; used for tweaking");
	REGISTER_CVAR(g_enableSpeedLean, 0, 0, "Enables player-controlled curve leaning in speed mode.");
	//
	REGISTER_CVAR(int_zoomAmount, 0.75f, VF_CHEAT, "Maximum zoom, between 0.0 and 1.0. Default = .75");
	REGISTER_CVAR(int_zoomInTime, 5.0f, VF_CHEAT, "Number of seconds it takes to zoom in. Default = 5.0");
	REGISTER_CVAR(int_moveZoomTime, 0.1f, VF_CHEAT, "Number of seconds it takes to zoom out when moving. Default = 0.2");
	REGISTER_CVAR(int_zoomOutTime, 0.1f, VF_CHEAT, "Number of seconds it takes to zoom out when you stop firing. Default = 0.5");

	REGISTER_FLOAT("aa_maxDist", 10.0f, VF_CHEAT, "max lock distance");

	REGISTER_CVAR(hr_rotateFactor, -.1f, VF_CHEAT, "rotate factor");
	REGISTER_CVAR(hr_rotateTime, .07f, VF_CHEAT, "rotate time");
	REGISTER_CVAR(hr_dotAngle, .75f, VF_CHEAT, "max angle for FOV change");
	REGISTER_CVAR(hr_fovAmt, .03f, VF_CHEAT, "goal FOV when hit");
	REGISTER_CVAR(hr_fovTime, .05f, VF_CHEAT, "fov time");

	// frozen shake vars (for tweaking only)
	REGISTER_CVAR(cl_debugFreezeShake, 0, VF_CHEAT|VF_DUMPTODISK, "Toggle freeze shake debug draw");  
	REGISTER_CVAR(cl_frozenSteps, 3, VF_CHEAT, "Number of steps for unfreeze shaking");  
	REGISTER_CVAR(cl_frozenSensMin, 1.0f, VF_CHEAT, "Frozen sensitivity min"); // was 0.2
	REGISTER_CVAR(cl_frozenSensMax, 1.0f, VF_CHEAT, "Frozen sensitivity max"); // was 0.4
	REGISTER_CVAR(cl_frozenAngleMin, 1.f, VF_CHEAT, "Frozen clamp angle min");
	REGISTER_CVAR(cl_frozenAngleMax, 10.f, VF_CHEAT, "Frozen clamp angle max");
	REGISTER_CVAR(cl_frozenMouseMult, 0.00015f, VF_CHEAT, "Frozen mouseshake multiplier");
  REGISTER_CVAR(cl_frozenKeyMult, 0.02f, VF_CHEAT, "Frozen movement keys multiplier");
	REGISTER_CVAR(cl_frozenSoundDelta, 0.004f, VF_CHEAT, "Threshold for unfreeze shake to trigger a crack sound");
	
	REGISTER_CVAR(g_frostDecay, 0.25f, VF_CHEAT, "Frost decay speed when freezing actors");

	REGISTER_CVAR(g_stanceTransitionSpeed, 15.0f, VF_CHEAT, "Set speed of camera transition from stance to stance");

	REGISTER_CVAR(g_playerHealthValue, 100, VF_CHEAT, "Maximum player health.");
	REGISTER_CVAR(g_walkMultiplier, 1, VF_SAVEGAME, "Modify movement speed");
	REGISTER_CVAR(g_suitRecoilEnergyCost, 15.0f, VF_CHEAT, "Subtracted energy when weapon is fired in strength mode.");
	REGISTER_CVAR(g_suitSpeedMult, 1.85f, 0, "Modify speed mode effect.");
	REGISTER_CVAR(g_suitSpeedMultMultiplayer, 0.35f, 0, "Modify speed mode effect for Multiplayer.");
	REGISTER_CVAR(g_suitArmorHealthValue, 200.0f, 0, "This defines how much damage is reduced by 100% energy, not considering recharge. The value should be between 1 and <SuitMaxEnergy>.");
	REGISTER_CVAR(g_suitSpeedEnergyConsumption, 110.0f, 0, "Energy reduction in speed mode per second.");
	REGISTER_CVAR(g_suitSpeedEnergyConsumptionMultiplayer, 50.0f, 0, "Energy reduction in speed mode per second in multiplayer.");
	REGISTER_CVAR(g_suitCloakEnergyDrainAdjuster, 1.0f, 0, "Multiplier for energy reduction in cloak mode.");
	REGISTER_CVAR(g_mpSpeedRechargeDelay, 1, VF_CHEAT, "Toggles delay when sprinting below 20% energy.");
	REGISTER_CVAR(g_AiSuitEnergyRechargeTime, 10.0f, VF_CHEAT, "Modify suit energy recharge for AI.");
	REGISTER_CVAR(g_AiSuitStrengthMeleeMult, 0.4f, VF_CHEAT, "Modify AI strength mode melee damage relative to player damage.");
	REGISTER_CVAR(g_AiSuitHealthRegenTime, 33.3f, VF_CHEAT, "Modify suit health recharge for AI.");
	REGISTER_CVAR(g_AiSuitArmorModeHealthRegenTime, 20.0f, VF_CHEAT, "Modify suit health recharge for AI in armor mode.");
	REGISTER_CVAR(g_playerSuitEnergyRechargeTime, 10.0f, VF_CHEAT, "Modify suit energy recharge for Player.");
	REGISTER_CVAR(g_playerSuitEnergyRechargeTimeArmor, 10.0f, VF_CHEAT, "Modify suit energy recharge for Player in singleplayer in armor mode.");
	REGISTER_CVAR(g_playerSuitEnergyRechargeTimeArmorMoving, 10.0f, VF_CHEAT, "Modify suit energy recharge for Player in singleplayer in armor mode while moving.");
	REGISTER_CVAR(g_playerSuitEnergyRechargeTimeMultiplayer, 20.0f, VF_CHEAT, "Modify suit energy recharge for Player in multiplayer.");
	REGISTER_CVAR(g_playerSuitEnergyRechargeDelay, 0.0f, VF_CHEAT, "Delay of energy recharge after the player has been hit.");
	REGISTER_CVAR(g_playerSuitHealthRegenTime, 35.0f, VF_CHEAT, "Modify suit health recharge for Player.");
	REGISTER_CVAR(g_playerSuitHealthRegenTimeMoving, 35.0f, VF_CHEAT, "Modify suit health recharge for moving Player.");
	REGISTER_CVAR(g_playerSuitArmorModeHealthRegenTime, 15.0f, VF_CHEAT, "Modify suit health recharge for Player in armor mode.");
	REGISTER_CVAR(g_playerSuitArmorModeHealthRegenTimeMoving, 30.0f, VF_CHEAT, "Modify suit health recharge for Player moving in armor mode.");
	REGISTER_CVAR(g_playerSuitHealthRegenDelay, 0.0f, VF_CHEAT, "Delay of health regeneration after the player has been hit.");
	REGISTER_CVAR(g_difficultyLevel, 0, VF_CHEAT|VF_READONLY, "Difficulty level");
	REGISTER_CVAR(g_difficultyHintSystem, 2, VF_CHEAT|VF_READONLY, "Lower difficulty hint system (0 is off, 1 is radius based, 2 is save-game based)");
	REGISTER_CVAR(g_difficultyRadius, 300, VF_CHEAT|VF_READONLY, "Radius in which player needs to die to display lower difficulty level hint.");
	REGISTER_CVAR(g_difficultyRadiusThreshold, 5, VF_CHEAT|VF_READONLY, "Number of times player has to die within radius to trigger difficulty hint.");
	REGISTER_CVAR(g_difficultySaveThreshold, 5, VF_CHEAT|VF_READONLY, "Number of times player has to die with same savegame active to trigger difficulty hint.");
	REGISTER_CVAR(g_pp_scale_income, 1, VF_CHEAT, "Scales incoming PP.");
	REGISTER_CVAR(g_pp_scale_price, 1, VF_CHEAT, "Scales PP prices.");
	REGISTER_CVAR(g_energy_scale_price, 0, VF_CHEAT, "Scales energy prices.");
	REGISTER_CVAR(g_energy_scale_income, 1, VF_CHEAT, "Scales incoming energy.");
	REGISTER_CVAR(g_enableFriendlyFallAndPlay, 0, 0, "Enables fall&play feedback for friendly actors.");
	
	REGISTER_CVAR(g_playerRespawns, 0, VF_SAVEGAME, "Sets the player lives.");
	REGISTER_CVAR(g_playerLowHealthThreshold, 40.0f, VF_CHEAT, "The player health threshold when the low health effect kicks in.");
	REGISTER_CVAR(g_punishFriendlyDeaths, 1, VF_CHEAT, "The player gets punished by death when killing a friendly unit.");
	REGISTER_CVAR(g_enableMPStealthOMeter, 0, VF_CHEAT, "Enables the stealth-o-meter to detect enemies in MP matches.");
	REGISTER_CVAR(g_meleeWhileSprinting, 0, 0, "Enables option to melee while sprinting, using left mouse button.");
	REGISTER_CVAR(g_fallAndPlayThreshold, 50, VF_CHEAT, "Minimum damage for fall and play.");

	// Depth of Field control
	REGISTER_CVAR(g_dofset_minScale, 1.0f, VF_CHEAT, "Scale Dof_FocusMin param when it gets set Default = 1");
	REGISTER_CVAR(g_dofset_maxScale, 3.0f, VF_CHEAT, "Scale Dof_FocusMax param when it gets set Default = 3");
	REGISTER_CVAR(g_dofset_limitScale, 9.0f, VF_CHEAT, "Scale Dof_FocusLimit param when it gets set Default = 9");
	REGISTER_CVAR(g_dof_minHitScale, 0.25f, VF_CHEAT, "Scale of ray hit distance which Min tries to approach. Default = 0.25");
	REGISTER_CVAR(g_dof_maxHitScale, 2.0f, VF_CHEAT, "Scale of ray hit distance which Max tries to approach. Default = 2.0f");
	REGISTER_CVAR(g_dof_sampleAngle, 5.0f, VF_CHEAT, "Sample angle in degrees. Default = 5");
	REGISTER_CVAR(g_dof_minAdjustSpeed, 100.0f, VF_CHEAT, "Speed that DoF can adjust the min value with. Default = 100");
	REGISTER_CVAR(g_dof_maxAdjustSpeed, 200.0f, VF_CHEAT, "Speed that DoF can adjust the max value with. Default = 200");
	REGISTER_CVAR(g_dof_averageAdjustSpeed, 20.0f, VF_CHEAT, "Speed that the average between min and max can be approached. Default = 20");
	REGISTER_CVAR(g_dof_distAppart, 10.0f, VF_CHEAT, "Minimum distance that max and min can be apart. Default = 10");
	REGISTER_CVAR(g_dof_ironsight, 1, VF_CHEAT, "Enable ironsight dof. Default = 1");
	REGISTER_CVAR(g_ColorGradingBlendTime, 3.0f, 0, "Time to blend from the last color grading chart to the next.");
	

	// explosion culling
	REGISTER_CVAR(g_ec_enable, 1, VF_CHEAT, "Enable/Disable explosion culling of small objects. Default = 1");
	REGISTER_CVAR(g_ec_radiusScale, 2.0f, VF_CHEAT, "Explosion culling scale to apply to explosion radius for object query.");
	REGISTER_CVAR(g_ec_volume, 0.75f, VF_CHEAT, "Explosion culling volume which needs to be exceed for objects to not be culled.");
	REGISTER_CVAR(g_ec_extent, 2.0f, VF_CHEAT, "Explosion culling length of an AABB side which needs to be exceed for objects to not be culled.");
	REGISTER_CVAR(g_ec_removeThreshold, 20, VF_CHEAT, "At how many items in exploding area will it start removing items.");

	REGISTER_CVAR(g_radialBlur, 1.0f, VF_CHEAT, "Radial blur on explosions. Default = 1, 0 to disable");
	REGISTER_CVAR(g_playerFallAndPlay, 0, 0, "When enabled, the player doesn't die from direct damage, but goes to fall and play.");
	
	REGISTER_CVAR(g_enableTracers, 1, 0, "Enable/Disable tracers.");
	REGISTER_CVAR(g_enableAlternateIronSight, 0, 0, "Enable/Disable alternate ironsight mode");
	REGISTER_CVAR(g_ragdollMinTime, 10.0f, 0, "minimum time in seconds that a ragdoll will be visible");
	REGISTER_CVAR(g_ragdollUnseenTime, 2.0f, 0, "time in seconds that the player has to look away from the ragdoll before it disappears");
	REGISTER_CVAR(g_ragdollPollTime, 0.5f, 0, "time in seconds where 'unseen' polling is done");
	REGISTER_CVAR(g_ragdollDistance, 10.0f, 0, "distance in meters that the player has to be away from the ragdoll before it can disappear");
	REGISTER_CVAR(g_debugaimlook, 0, VF_CHEAT, "Debug aim/look direction");
	REGISTER_CVAR(g_enableIdleCheck, 1, 0,"");

	// Crysis supported gamemode CVars
	REGISTER_CVAR(g_timelimit, 60.0f, 0, "Duration of a time-limited game (in minutes). Default is 0, 0 means no time-limit.");
	REGISTER_CVAR(g_roundtime, 2.0f, 0, "Duration of a round (in minutes). Default is 0, 0 means no time-limit.");
	REGISTER_CVAR(g_preroundtime, 8, 0, "Frozen time before round starts. Default is 8, 0 Disables freeze time.");
	REGISTER_CVAR(g_suddendeathtime, 30, 0, "Number of seconds before round end to start sudden death. Default if 30. 0 Disables sudden death.");
	REGISTER_CVAR(g_roundlimit, 30, 0, "Maximum numbers of rounds to be played. Default is 0, 0 means no limit.");
	REGISTER_CVAR(g_fraglimit, 0, 0, "Number of frags before a round restarts. Default is 0, 0 means no frag-limit.");
  REGISTER_CVAR(g_fraglead, 1, 0, "Number of frags a player has to be ahead of other players once g_fraglimit is reached. Default is 1.");
  REGISTER_CVAR(g_friendlyfireratio, 1.0f, 0, "Sets friendly damage ratio.");
  REGISTER_CVAR(g_revivetime, 20, 0, "Revive wave timer.");
  REGISTER_CVAR(g_autoteambalance, 0, 0, "Enables auto team balance.");
	REGISTER_CVAR(g_minplayerlimit, 2, 0, "Minimum number of players to start a match.");
	REGISTER_CVAR(g_minteamlimit, 1, 0, "Minimum number of players in each team to start a match.");
	REGISTER_CVAR(g_tk_punish, 1, 0, "Turns on punishment for team kills");
	REGISTER_CVAR(g_tk_punish_limit, 5, 0, "Number of team kills user will be banned for");
	REGISTER_CVAR(g_teamlock, 2, 0, "Number of players one team needs to have over the other, for the game to deny joining it. 0 disables.");

	REGISTER_CVAR(g_debugNetPlayerInput, 0, VF_CHEAT, "Show some debug for player input");
	REGISTER_CVAR(g_debug_fscommand, 0, 0, "Print incoming fscommands to console");
	REGISTER_CVAR(g_debugDirectMPMenu, 0, 0, "Jump directly to MP menu on application start.");
	REGISTER_CVAR(g_skipIntro, 0, VF_CHEAT, "Skip all the intro videos.");
	REGISTER_CVAR(g_resetActionmapOnStart, 0, 0, "Resets Keyboard mapping on application start.");
	REGISTER_CVAR(g_useProfile, 1, 0, "Don't save anything to or load anything from profile.");
	REGISTER_CVAR(g_startFirstTime, 1, VF_DUMPTODISK, "1 before the game was started first time ever.");
	REGISTER_CVAR(g_cutsceneSkipDelay, 0.0f, 0, "Skip Delay for Cutscenes.");

	//
  REGISTER_CVAR(g_godMode, 0, VF_CHEAT, "God Mode");
  REGISTER_CVAR(g_detachCamera, 0, VF_CHEAT, "Detach camera");

  REGISTER_CVAR(g_debugCollisionDamage, 0, VF_DUMPTODISK, "Log collision damage");
	REGISTER_CVAR(g_debugHits, 0, VF_DUMPTODISK, "Log hits");
  REGISTER_CVAR(g_trooperProneMinDistance, 10, VF_DUMPTODISK, "Distance to move for trooper to switch to prone stance");
//	REGISTER_CVAR(, 0, VF_DUMPTODISK, "Max value for trooper tentacle dynamic physics/anim blending");
//	REGISTER_CVAR(, 100.f, VF_DUMPTODISK, "Trooper tentacle dynamic physics/anim blending speed");
	REGISTER_CVAR(g_trooperTentacleAnimBlend, 0, VF_DUMPTODISK, "Trooper tentacle physic_anim blend (0..1) - overrides the physic_blend AG parameter when it's not 0");
	REGISTER_CVAR(g_trooperBankingMultiplier, 1, VF_DUMPTODISK, "Trooper banking multiplier coeff (0..x)");
	REGISTER_CVAR(g_alienPhysicsAnimRatio, 0.0f, VF_CHEAT,"" );  
  
	REGISTER_CVAR(pl_debug_ladders, 0, VF_CHEAT,"");
	REGISTER_CVAR(pl_debug_movement, 0, VF_CHEAT,"");
	REGISTER_CVAR(pl_debug_jumping, 0, VF_CHEAT,"");
	pl_debug_filter = REGISTER_STRING("pl_debug_filter","",VF_CHEAT,"");

	REGISTER_CVAR(aln_debug_movement, 0, VF_CHEAT,"");
	aln_debug_filter = REGISTER_STRING("aln_debug_filter","",VF_CHEAT,"");

	// emp grenade
	REGISTER_CVAR(g_empStyle, 0, VF_CHEAT, "");
	REGISTER_CVAR(g_empNanosuitDowntime, 10.0f, VF_CHEAT, "Time that the nanosuit is deactivated after leaving the EMP field.");

	// hud cvars
// 	REGISTER_CVAR(hud_mpNamesDuration, 2, 0, "MP names will fade after this duration.");
// 	REGISTER_CVAR(hud_mpNamesNearDistance, 1, 0, "MP names will be fully visible when nearer than this.");
// 	REGISTER_CVAR(hud_mpNamesFarDistance, 100, 0, "MP names will be fully invisible when farther than this.");
// 	REGISTER_CVAR(hud_onScreenNearDistance, 10, 0, "On screen icons won't scale anymore, when nearer than this.");
// 	REGISTER_CVAR(hud_onScreenFarDistance, 500, 0, "On screen icons won't scale anymore, when farther than this.");
// 	REGISTER_CVAR(hud_onScreenNearSize, 1.4f, 0, "On screen icon size when nearest.");
// 	REGISTER_CVAR(hud_onScreenFarSize, 0.7f, 0, "On screen icon size when farthest.");
// 	REGISTER_CVAR(hud_colorLine, 4481854, 0, "HUD line color.");
// 	REGISTER_CVAR(hud_colorOver, 14125840, 0, "HUD hovered color.");
// 	REGISTER_CVAR(hud_colorText, 12386209, 0, "HUD text color.");
// 	REGISTER_CVAR(hud_voicemode, 1, 0, "Usage of the voice when switching of Nanosuit mode.");
// 	REGISTER_CVAR(hud_enableAlienInterference, 1, VF_SAVEGAME, "Switched the alien interference effect.");
// 	REGISTER_CVAR(hud_alienInterferenceStrength, 0.8f, VF_SAVEGAME, "Scales alien interference effect strength.");
// 	REGISTER_CVAR(hud_godFadeTime, 3, VF_CHEAT, "sets the fade time of the god mode message");
// 	REGISTER_CVAR(hud_crosshair_enable, 1,0, "Toggles singleplayer crosshair visibility.")->SetOnChangeCallback(CHUD::OnCrosshairCVarChanged);
// 	REGISTER_CVAR(hud_crosshair, 1,0, "Select the crosshair (1-8)")->SetOnChangeCallback(CHUD::OnCrosshairCVarChanged);
// 	REGISTER_CVAR(hud_chDamageIndicator, 1,0,"Switch crosshair-damage indicator... (1 on, 0 off)");
// 	REGISTER_CVAR(hud_showAllObjectives, 0, 0, "Show all on screen objectives, not only the active one.");
// 	REGISTER_CVAR(hud_panoramicHeight, 10,0,"Set screen border for 'cinematic view' in percent.")->SetOnChangeCallback(CHUD::OnSubtitlePanoramicHeightCVarChanged);
// 	REGISTER_CVAR(hud_subtitles, 0,0,"Subtitle mode. 0==Off, 1=All, 2=CutscenesOnly")->SetOnChangeCallback(CHUD::OnSubtitleCVarChanged);
// 	REGISTER_CVAR(hud_subtitlesDebug, 0,0,"Debug subtitles");
// 	REGISTER_CVAR(hud_subtitlesRenderMode, 0,0,"Subtitle RenderMode. 0==Flash, 1=3DEngine");
// 	REGISTER_CVAR(hud_subtitlesFontSize, 16, 0, "FontSize for Subtitles.");
// 	REGISTER_CVAR(hud_subtitlesHeight, 10, 0,"Height of Subtitles in Percent. Normally same as hud_PanoramicHeight");
// 	REGISTER_CVAR(hud_subtitlesShowCharName, 1, 0,"Show Character talking along with Subtitle");
// 	REGISTER_CVAR(hud_subtitlesQueueCount, 1, 0,"Maximum amount of subtitles in Update Queue");
// 	REGISTER_CVAR(hud_subtitlesVisibleCount, 1, 0,"Maximum amount of subtitles in Visible Queue");
// 	REGISTER_CVAR(hud_attachBoughtEquipment, 0,VF_CHEAT,"Attach equipment in PS equipment packs to the last bought/selected weapon.");
// 	REGISTER_CVAR(hud_radarBackground, 1, 0, "Switches the miniMap-background for the radar.");
// 	REGISTER_CVAR(hud_radarJammingEffectScale, 0.75f, 0, "Scales the intensity of the radar jamming effect.");
// 	REGISTER_CVAR(hud_radarJammingThreshold, 0.99f, 0, "Threshold to disable the radar (independent from effect).");
// 	REGISTER_CVAR(hud_startPaused, 1, 0, "The game starts paused, waiting for user input.");
// 	REGISTER_CVAR(hud_faderDebug, 0, 0, "Show Debug Information for FullScreen Faders.");
// 	REGISTER_CVAR(hud_nightVisionConsumption, 0.5f, VF_CHEAT, "Scales the energy consumption of the night vision.");
// 	REGISTER_CVAR(hud_nightVisionRecharge, 2.0f, VF_CHEAT, "Scales the energy recharge of the night vision.");
// 	REGISTER_CVAR(hud_showBigVehicleReload, 0, 0, "Enables an additional reload bar around the crosshair in big vehicles.");
// 	REGISTER_CVAR(hud_binocsScanningDelay, 0.55f, VF_CHEAT, "Defines the delay in seconds the binoculars take to scan an object.");
// 	REGISTER_CVAR(hud_binocsScanningWidth, 0.3f, VF_CHEAT, "Defines the width/height in which the binocular raycasts are offset from the center to scan objects.");

	// Controller aim helper cvars
	REGISTER_CVAR(aim_assistSearchBox, 100.0f, 0, "The area autoaim looks for enemies within");
	REGISTER_CVAR(aim_assistMaxDistance, 150.0f, 0, "The maximum range at which autoaim operates");
	REGISTER_CVAR(aim_assistSnapDistance, 3.0f, 0, "The maximum deviation autoaim is willing to compensate for");
	REGISTER_CVAR(aim_assistVerticalScale, 0.75f, 0, "The amount of emphasis on vertical correction (the less the number is the more vertical component is compensated)");
	REGISTER_CVAR(aim_assistSingleCoeff, 1.0f, 0, "The scale of single-shot weapons' aim assistance");
	REGISTER_CVAR(aim_assistAutoCoeff, 0.5f, 0, "The scale of auto weapons' aim assistance at continuous fire");
	REGISTER_CVAR(aim_assistRestrictionTimeout, 20.0f, 0, "The restriction timeout on aim assistance after user uses a mouse");


	
	// Controller control
	REGISTER_CVAR(hud_aspectCorrection, 2, 0, "Aspect ratio corrections for controller rotation: 0-off, 1-direct, 2-inverse");
	REGISTER_CVAR(hud_ctrl_Curve_X, 3.0f, 0, "Analog controller X rotation curve");
	REGISTER_CVAR(hud_ctrl_Curve_Z, 3.0f, 0, "Analog controller Z rotation curve");
	REGISTER_CVAR(hud_ctrl_Coeff_X, 3.5f*3.5f, 0, "Analog controller X rotation scale"); // was 3.5*3.5 but aspect ratio correction does the scaling now! adjust only if that gives no satisfactory results
	REGISTER_CVAR(hud_ctrl_Coeff_Z, 5.0f*5.0f, 0, "Analog controller Z rotation scale");
	REGISTER_CVAR(hud_ctrlZoomMode, 0, 0, "Weapon aiming mode with controller. 0 is same as mouse zoom, 1 cancels at release");

	REGISTER_CVAR(g_combatFadeTime, 17.0f, 0, "sets the battle fade time in seconds ");
	REGISTER_CVAR(g_combatFadeTimeDelay, 7.0f, 0, "waiting time before the battle starts fading out, in seconds ");
	REGISTER_CVAR(g_battleRange, 50.0f, 0, "sets the battle range in meters ");

	// Assistance switches
	REGISTER_CVAR(aim_assistAimEnabled, 1, 0, "Enable/disable aim assitance on aim zooming");
	REGISTER_CVAR(aim_assistTriggerEnabled, 1, 0, "Enable/disable aim assistance on firing the weapon");
	REGISTER_CVAR(hit_assistSingleplayerEnabled, 1, 0, "Enable/disable minimum damage hit assistance");
	REGISTER_CVAR(hit_assistMultiplayerEnabled, 1, 0, "Enable/disable minimum damage hit assistance in multiplayer games");

	//movement cvars
  REGISTER_CVAR(v_profileMovement, 0, 0, "Used to enable profiling of the current vehicle movement (1 to enable)");    
  REGISTER_CVAR(v_pa_surface, 1, VF_CHEAT, "Enables/disables vehicle surface particles");
  REGISTER_CVAR(v_wind_minspeed, 0.f, VF_CHEAT, "If non-zero, vehicle wind areas always set wind >= specified value");
  REGISTER_CVAR(v_draw_suspension, 0, VF_DUMPTODISK, "Enables/disables display of wheel suspension, for the vehicle that has v_profileMovement enabled");
  REGISTER_CVAR(v_draw_slip, 0, VF_DUMPTODISK, "Draw wheel slip status");  
  REGISTER_CVAR(v_invertPitchControl, 0, VF_DUMPTODISK, "Invert the pitch control for driving some vehicles, including the helicopter and the vtol");
  REGISTER_CVAR(v_sprintSpeed, 0.f, 0, "Set speed for acceleration measuring");
  REGISTER_CVAR(v_rockBoats, 1, 0, "Enable/disable boats idle rocking");  
  REGISTER_CVAR(v_dumpFriction, 0, 0, "Dump vehicle friction status");
  REGISTER_CVAR(v_debugSounds, 0, 0, "Enable/disable vehicle sound debug drawing");
  REGISTER_CVAR(v_debugMountedWeapon, 0, 0, "Enable/disable vehicle mounted weapon camera debug draw");

	pAltitudeLimitCVar = REGISTER_CVAR(v_altitudeLimit, v_altitudeLimitDefault(), VF_CHEAT, "Used to restrict the helicopter and VTOL movement from going higher than a set altitude. If set to zero, the altitude limit is disabled.");
	pAltitudeLimitLowerOffsetCVar = REGISTER_CVAR(v_altitudeLimitLowerOffset, 0.1f, VF_CHEAT, "Used in conjunction with v_altitudeLimit to set the zone when gaining altitude start to be more difficult.");
  REGISTER_CVAR(v_help_tank_steering, 0, 0, "Enable tank steering help for AI");

	REGISTER_CVAR(v_stabilizeVTOL, 0.35f, VF_DUMPTODISK, "Specifies if the air movements should automatically stabilize");

  	
	REGISTER_CVAR(pl_swimBaseSpeed, 4.0f, VF_CHEAT, "Swimming base speed.");
	REGISTER_CVAR(pl_swimBackSpeedMul, 0.8f, VF_CHEAT, "Swimming backwards speed mul.");
	REGISTER_CVAR(pl_swimSideSpeedMul, 0.9f, VF_CHEAT, "Swimming sideways speed mul.");
	REGISTER_CVAR(pl_swimVertSpeedMul, 0.5f, VF_CHEAT, "Swimming vertical speed mul.");
	REGISTER_CVAR(pl_swimNormalSprintSpeedMul, 1.5f, VF_CHEAT, "Swimming Non-Speed sprint speed mul.");
	REGISTER_CVAR(pl_swimSpeedSprintSpeedMul, 2.5f, VF_CHEAT, "Swimming Speed sprint speed mul.");
	REGISTER_CVAR(pl_swimUpSprintSpeedMul, 2.0f, VF_CHEAT, "Swimming sprint while looking up (dolphin rocket).");
	REGISTER_CVAR(pl_swimJumpStrengthCost, 50.0f, VF_CHEAT, "Swimming strength shift+jump energy cost (dolphin rocket).");
	REGISTER_CVAR(pl_swimJumpStrengthSprintMul, 2.5f, VF_CHEAT, "Swimming strength shift+jump velocity mul (dolphin rocket).");
	REGISTER_CVAR(pl_swimJumpStrengthBaseMul, 1.0f, VF_CHEAT, "Swimming strength normal jump velocity mul (dolphin rocket).");
	REGISTER_CVAR(pl_swimJumpSpeedCost, 50.0f, VF_CHEAT, "Swimming speed shift+jump energy cost (dolphin rocket).");
	REGISTER_CVAR(pl_swimJumpSpeedSprintMul, 2.5f, VF_CHEAT, "Swimming speed shift+jump velocity mul (dolphin rocket).");
	REGISTER_CVAR(pl_swimJumpSpeedBaseMul, 1.0f, VF_CHEAT, "Swimming speed normal jump velocity mul (dolphin rocket).");

	REGISTER_CVAR(pl_fallDamage_Normal_SpeedSafe, 8.0f, VF_CHEAT, "Safe fall speed (in all modes, including strength jump on flat ground).");
	REGISTER_CVAR(pl_fallDamage_Normal_SpeedFatal, 13.7f, VF_CHEAT, "Fatal fall speed in armor mode (13.5 m/s after falling freely for ca 20m).");
	REGISTER_CVAR(pl_fallDamage_SpeedBias, 1.5f, VF_CHEAT, "Damage bias for medium fall speed: =1 linear, <1 more damage, >1 less damage.");
	REGISTER_CVAR(pl_debugFallDamage, 0, VF_CHEAT, "Enables console output of fall damage information.");
	

	REGISTER_CVAR(pl_zeroGSpeedMultNormal, 1.2f, VF_CHEAT, "Modify movement speed in zeroG, in normal mode.");
	REGISTER_CVAR(pl_zeroGSpeedMultNormalSprint, 1.7f, VF_CHEAT, "Modify movement speed in zeroG, in normal sprint.");
  REGISTER_CVAR(pl_zeroGSpeedMultSpeed, 1.7f, VF_CHEAT, "Modify movement speed in zeroG, in speed mode.");
	REGISTER_CVAR(pl_zeroGSpeedMultSpeedSprint, 5.0f, VF_CHEAT, "Modify movement speed in zeroG, in speed sprint.");
	REGISTER_CVAR(pl_zeroGUpDown, 1.0f, 0, "Scales the z-axis movement speed in zeroG.");
	REGISTER_CVAR(pl_zeroGBaseSpeed, 3.0f, 0, "Maximum player speed request limit for zeroG.");
	REGISTER_CVAR(pl_zeroGSpeedMaxSpeed, -1.0f, 0, "(DEPRECATED) Maximum player speed request limit for zeroG while in speed mode.");
	REGISTER_CVAR(pl_zeroGSpeedModeEnergyConsumption, 0.5f, 0, "Percentage consumed per second while speed sprinting in ZeroG.");
	REGISTER_CVAR(pl_zeroGDashEnergyConsumption, 0.25f, 0, "Percentage consumed when doing a dash in ZeroG.");
	REGISTER_CVAR(pl_zeroGSwitchableGyro, 0, 0, "MERGE/REVERT");
	REGISTER_CVAR(pl_zeroGEnableGBoots, 0, 0, "Switch G-Boots action on/off (if button assigned).");
	REGISTER_CVAR(pl_zeroGThrusterResponsiveness, 0.3f, VF_CHEAT, "Thrusting responsiveness.");
	REGISTER_CVAR(pl_zeroGFloatDuration, 1.25f, VF_CHEAT, "Floating duration until full stop (after stopped thrusting).");
	REGISTER_CVAR(pl_zeroGParticleTrail, 0, 0, "Enable particle trail when in zerog.");
	REGISTER_CVAR(pl_zeroGEnableGyroFade, 2, VF_CHEAT, "Enable fadeout of gyro-stabilizer for vertical view angles (2=disable speed fade as well).");
	REGISTER_CVAR(pl_zeroGGyroFadeAngleInner, 20.0f, VF_CHEAT, "ZeroG gyro inner angle (default is 20).");
	REGISTER_CVAR(pl_zeroGGyroFadeAngleOuter, 60.0f, VF_CHEAT, "ZeroG gyro outer angle (default is 60).");
	REGISTER_CVAR(pl_zeroGGyroFadeExp, 2.0f, VF_CHEAT, "ZeroG gyro angle bias (default is 2.0).");
	REGISTER_CVAR(pl_zeroGGyroStrength, 1.0f, VF_CHEAT, "ZeroG gyro strength (default is 1.0).");
	REGISTER_CVAR(pl_zeroGAimResponsiveness, 8.0f, VF_CHEAT, "ZeroG aim responsiveness vs. inertia (default is 8.0).");

	// weapon system
	i_debuggun_1 = REGISTER_STRING("i_debuggun_1", "ai_statsTarget", VF_DUMPTODISK, "Command to execute on primary DebugGun fire");
	i_debuggun_2 = REGISTER_STRING("i_debuggun_2", "ag_debug", VF_DUMPTODISK, "Command to execute on secondary DebugGun fire");

	REGISTER_CVAR(tracer_min_distance, 4.0f, 0, "Distance at which to start scaling/lengthening tracers.");
	REGISTER_CVAR(tracer_max_distance, 50.0f, 0, "Distance at which to stop scaling/lengthening tracers.");
	REGISTER_CVAR(tracer_min_scale, 0.5f, 0, "Scale at min distance.");
	REGISTER_CVAR(tracer_max_scale, 5.0f, 0, "Scale at max distance.");
	REGISTER_CVAR(tracer_max_count, 32, 0, "Max number of active tracers.");
	REGISTER_CVAR(tracer_player_radiusSqr, 400.0f, 0, "Sqr Distance around player at which to start decelerate/acelerate tracer speed.");

	REGISTER_CVAR(i_debug_projectiles, 0, VF_CHEAT, "Displays info about projectile status, where available.");
	REGISTER_CVAR(i_auto_turret_target, 1, VF_CHEAT, "Enables/Disables auto turrets aquiring targets.");
	REGISTER_CVAR(i_auto_turret_target_tacshells, 0, 0, "Enables/Disables auto turrets aquiring TAC shells as targets");

	REGISTER_CVAR(i_debug_zoom_mods, 0, VF_CHEAT, "Use zoom mode spread/recoil mods");
  REGISTER_CVAR(i_debug_sounds, 0, VF_CHEAT, "Enable item sound debugging");
  REGISTER_CVAR(i_debug_turrets, 0, VF_CHEAT, 
    "Enable GunTurret debugging.\n"
    "Values:\n"
    "0:  off"
    "1:  basics\n"
    "2:  prediction\n"
    "3:  sweeping\n"
    "4:  searching\n"      
    "5:  deviation\n"    
    );
	REGISTER_CVAR(i_debug_mp_flowgraph, 0, VF_CHEAT, "Displays info on the MP flowgraph node");
  
	REGISTER_CVAR(h_turnSpeed, 1.3f, 0,"");

  // quick game

  g_quickGame_map = REGISTER_STRING("g_quickGame_map","",VF_DUMPTODISK, "QuickGame option");
  g_quickGame_mode = REGISTER_STRING("g_quickGame_mode","PowerStruggle", VF_DUMPTODISK, "QuickGame option");
  REGISTER_CVAR(g_quickGame_min_players,0,VF_DUMPTODISK,"QuickGame option");
  REGISTER_CVAR(g_quickGame_prefer_lan,0,VF_DUMPTODISK,"QuickGame option");
  REGISTER_CVAR(g_quickGame_prefer_favorites,0,VF_DUMPTODISK,"QuickGame option");
  REGISTER_CVAR(g_quickGame_prefer_my_country,0,VF_DUMPTODISK,"QuickGame option");
  REGISTER_CVAR(g_quickGame_ping1_level,80,VF_DUMPTODISK,"QuickGame option");
  REGISTER_CVAR(g_quickGame_ping2_level,170,VF_DUMPTODISK,"QuickGame option");

	REGISTER_CVAR(g_quickGame_debug,0,VF_CHEAT,"QuickGame option");
	
	REGISTER_CVAR(g_displayIgnoreList,1,VF_DUMPTODISK,"Display ignore list in chat tab.");
  REGISTER_CVAR(g_buddyMessagesIngame,1,VF_DUMPTODISK,"Output incoming buddy messages in chat while playing game.");

	REGISTER_INT("g_showIdleStats", 0,VF_NULL,"");

	// battledust
	REGISTER_CVAR(g_battleDust_enable, 1, 0, "Enable/Disable battledust");
	REGISTER_CVAR(g_battleDust_debug, 0, 0, "0: off, 1: text, 2: text+gfx");
	g_battleDust_effect = REGISTER_STRING("g_battleDust_effect", "misc.battledust.light", 0, "Sets the effect to use for battledust");
	
	REGISTER_CVAR(g_PSTutorial_Enabled, 1, 0, "Enable/disable powerstruggle tutorial");

	REGISTER_CVAR(g_proneNotUsableWeapon_FixType, 1, 0, "Test various fixes for not selecting hurricane while prone");
	REGISTER_CVAR(g_proneAimAngleRestrict_Enable, 1, 0, "Test fix for matching aim restrictions between 1st and 3rd person");

	REGISTER_CVAR(g_GDC09, 0, VF_CHEAT, "Enables hacks for GDC09.");
	REGISTER_CVAR(g_GDC09_input_smoothing, 0.0f, VF_CHEAT, "Smoothes rotation input in GDC demo.");
	
  REGISTER_CVAR(sv_votingTimeout, 60, 0, "Voting timeout");
  REGISTER_CVAR(sv_votingCooldown, 180, 0, "Voting cooldown");
  REGISTER_CVAR(sv_votingRatio, 0.51f, 0, "Part of player's votes needed for successful vote.");
	REGISTER_CVAR(sv_votingTeamRatio, 0.67f, 0, "Part of team member's votes needed for successful vote.");

	REGISTER_CVAR(sv_input_timeout, 0, 0, "Experimental timeout in ms to stop interpolating client inputs since last update.");

	REGISTER_CVAR(g_spectate_TeamOnly, 1, 0, "If true, you can only spectate players on your team");
	REGISTER_CVAR(g_claymore_limit, 3, 0, "Max claymores a player can place (recycled above this value)");
	REGISTER_CVAR(g_avmine_limit, 3, 0, "Max avmines a player can place (recycled above this value)");
	REGISTER_CVAR(g_debugMines, 0, 0, "Enable debug output for mines and claymores");

  REGISTER_CVAR(aim_assistCrosshairSize, 25, VF_CHEAT, "screen size used for crosshair aim assistance");
  REGISTER_CVAR(aim_assistCrosshairDebug, 0, VF_CHEAT, "debug crosshair aim assistance");

	REGISTER_CVAR(g_deathCam, 1, 0, "Enables / disables the MP death camera (shows the killer's location)");

	REGISTER_CVAR(sv_pacifist, 0, 0, "Pacifist mode (only works on dedicated server)");

	REGISTER_CVAR2( "e_Flocks",&CFlock::m_e_flocks,1,0,"Enable Flocks (Birds/Fishes)" );
	REGISTER_CVAR2( "e_FlocksHunt",&CFlock::m_e_flocks_hunt,1,0,"Birds will fall down..." );
 
	pVehicleQuality = pConsole->GetCVar("v_vehicle_quality");		assert(pVehicleQuality);

  NetInputChainInitCVars();
}

//------------------------------------------------------------------------
void SCVars::ReleaseCVars()
{
	IConsole* pConsole = gEnv->pConsole;

	pConsole->UnregisterVariable("cl_fov", true);
	pConsole->UnregisterVariable("cl_bob", true);
	pConsole->UnregisterVariable("cl_tpvDist", true);
	pConsole->UnregisterVariable("cl_tpvYaw", true);
	pConsole->UnregisterVariable("cl_nearPlane", true);
	pConsole->UnregisterVariable("cl_sprintShake", true);
	pConsole->UnregisterVariable("cl_sensitivityZeroG", true);
	pConsole->UnregisterVariable("cl_sensitivity", true);
	pConsole->UnregisterVariable("cl_invertMouse", true);
	pConsole->UnregisterVariable("cl_invertController", true);
	pConsole->UnregisterVariable("cl_crouchToggle", true);
	pConsole->UnregisterVariable("cl_fpBody", true);
	pConsole->UnregisterVariable("cl_hud", true);

	pConsole->UnregisterVariable("i_staticfiresounds", true);
	pConsole->UnregisterVariable("i_soundeffects", true);
	pConsole->UnregisterVariable("i_lighteffects", true);
	pConsole->UnregisterVariable("i_particleeffects", true);
	pConsole->UnregisterVariable("i_offset_front", true);
	pConsole->UnregisterVariable("i_offset_up", true);
	pConsole->UnregisterVariable("i_offset_right", true);
	pConsole->UnregisterVariable("i_unlimitedammo", true);
	pConsole->UnregisterVariable("i_iceeffects", true);

	pConsole->UnregisterVariable("cl_strengthscale", true);

	pConsole->UnregisterVariable("cl_motionBlur", true);
	pConsole->UnregisterVariable("cl_sprintBlur", true);
	pConsole->UnregisterVariable("cl_hitShake", true);
	pConsole->UnregisterVariable("cl_hitBlur", true);

	pConsole->UnregisterVariable("cl_righthand", true);
	pConsole->UnregisterVariable("cl_screeneffects", true);

	pConsole->UnregisterVariable("pl_inputAccel", true);

	pConsole->UnregisterVariable("cl_actorsafemode", true);
	pConsole->UnregisterVariable("g_hunterIK", true);
	pConsole->UnregisterVariable("g_tentacle_joint_limit", true);
	pConsole->UnregisterVariable("g_enableSpeedLean", true);

	pConsole->UnregisterVariable("int_zoomAmount", true);
	pConsole->UnregisterVariable("int_zoomInTime", true);
	pConsole->UnregisterVariable("int_moveZoomTime", true);
	pConsole->UnregisterVariable("int_zoomOutTime", true);

	pConsole->UnregisterVariable("aa_maxDist", true);

	pConsole->UnregisterVariable("hr_rotateFactor", true);
	pConsole->UnregisterVariable("hr_rotateTime", true);
	pConsole->UnregisterVariable("hr_dotAngle", true);
	pConsole->UnregisterVariable("hr_fovAmt", true);
	pConsole->UnregisterVariable("hr_fovTime", true);

	pConsole->UnregisterVariable("cl_debugFreezeShake", true);  
	pConsole->UnregisterVariable("cl_frozenSteps", true);  
	pConsole->UnregisterVariable("cl_frozenSensMin", true);
	pConsole->UnregisterVariable("cl_frozenSensMax", true);
	pConsole->UnregisterVariable("cl_frozenAngleMin", true);
	pConsole->UnregisterVariable("cl_frozenAngleMax", true);
	pConsole->UnregisterVariable("cl_frozenMouseMult", true);
	pConsole->UnregisterVariable("cl_frozenKeyMult", true);
	pConsole->UnregisterVariable("cl_frozenSoundDelta", true);
	
	pConsole->UnregisterVariable("g_frostDecay", true);

	pConsole->UnregisterVariable("g_stanceTransitionSpeed", true);

	pConsole->UnregisterVariable("g_playerHealthValue", true);
	pConsole->UnregisterVariable("g_walkMultiplier", true);
	pConsole->UnregisterVariable("g_suitSpeedMult", true);
	pConsole->UnregisterVariable("g_suitRecoilEnergyCost", true);
	pConsole->UnregisterVariable("g_suitSpeedMultMultiplayer", true);
	pConsole->UnregisterVariable("g_suitArmorHealthValue", true);
	pConsole->UnregisterVariable("g_suitSpeedEnergyConsumption", true);
	pConsole->UnregisterVariable("g_suitSpeedEnergyConsumptionMultiplayer", true);

	pConsole->UnregisterVariable("g_AiSuitEnergyRechargeTime", true);
	pConsole->UnregisterVariable("g_AiSuitHealthRechargeTime", true);
	pConsole->UnregisterVariable("g_AiSuitArmorModeHealthRegenTime", true);
	pConsole->UnregisterVariable("g_AiSuitStrengthMeleeMult", true);
	pConsole->UnregisterVariable("g_playerSuitEnergyRechargeTime", true);
	pConsole->UnregisterVariable("g_playerSuitEnergyRechargeTimeArmor", true);
	pConsole->UnregisterVariable("g_playerSuitEnergyRechargeTimeArmorMoving", true);
	pConsole->UnregisterVariable("g_playerSuitEnergyRechargeTimeMultiplayer", true);
	pConsole->UnregisterVariable("g_playerSuitHealthRechargeTime", true);
	pConsole->UnregisterVariable("g_playerSuitArmorModeHealthRegenTime", true);
	pConsole->UnregisterVariable("g_playerSuitHealthRechargeTimeMoving", true);
	pConsole->UnregisterVariable("g_playerSuitArmorModeHealthRegenTimeMoving", true);

	pConsole->UnregisterVariable("g_pp_scale_income", true);
	pConsole->UnregisterVariable("g_pp_scale_price", true);

	pConsole->UnregisterVariable("g_radialBlur", true);
	pConsole->UnregisterVariable("g_PlayerFallAndPlay", true);
	pConsole->UnregisterVariable("g_fallAndPlayThreshold", true);

	pConsole->UnregisterVariable("g_enableAlternateIronSight",true);
	pConsole->UnregisterVariable("g_enableTracers", true);
	pConsole->UnregisterVariable("g_meleeWhileSprinting", true);

	pConsole->UnregisterVariable("g_timelimit", true);
	pConsole->UnregisterVariable("g_teamlock", true);
	pConsole->UnregisterVariable("g_roundlimit", true);
	pConsole->UnregisterVariable("g_preroundtime", true);
	pConsole->UnregisterVariable("g_suddendeathtime", true);
	pConsole->UnregisterVariable("g_roundtime", true);
	pConsole->UnregisterVariable("g_fraglimit", true);
	pConsole->UnregisterVariable("g_fraglead", true);
	pConsole->UnregisterVariable("g_debugNetPlayerInput", true);
	pConsole->UnregisterVariable("g_debug_fscommand", true);
	pConsole->UnregisterVariable("g_debugDirectMPMenu", true);
	pConsole->UnregisterVariable("g_skipIntro", true);
	pConsole->UnregisterVariable("g_resetActionmapOnStart", true);
	pConsole->UnregisterVariable("g_useProfile", true);
	pConsole->UnregisterVariable("g_startFirstTime", true);

	pConsole->UnregisterVariable("g_tk_punish", true);
	pConsole->UnregisterVariable("g_tk_punish_limit", true);

	pConsole->UnregisterVariable("g_godMode", true);
	pConsole->UnregisterVariable("g_detachCamera", true);

	pConsole->UnregisterVariable("g_debugCollisionDamage", true);
	pConsole->UnregisterVariable("g_debugHits", true);
	pConsole->UnregisterVariable("g_trooperProneMinDistance", true);
	pConsole->UnregisterVariable("g_trooperTentacleAnimBlend", true);
	pConsole->UnregisterVariable("g_trooperBankingMultiplier", true);

	pConsole->UnregisterVariable("v_profileMovement", true);    
	pConsole->UnregisterVariable("v_pa_surface", true);
	pConsole->UnregisterVariable("v_wind_minspeed", true);
	pConsole->UnregisterVariable("v_draw_suspension", true);
	pConsole->UnregisterVariable("v_draw_slip", true);  
	pConsole->UnregisterVariable("v_invertPitchControl", true);
	pConsole->UnregisterVariable("v_sprintSpeed", true);
	pConsole->UnregisterVariable("v_rockBoats", true);  
  pConsole->UnregisterVariable("v_debugMountedWeapon", true);  
	pConsole->UnregisterVariable("v_zeroGSpeedMultSpeed", true);
	pConsole->UnregisterVariable("v_zeroGSpeedMultSpeedSprint", true);
	pConsole->UnregisterVariable("v_zeroGSpeedMultNormal", true);
	pConsole->UnregisterVariable("v_zeroGSpeedMultNormalSprint", true);
	pConsole->UnregisterVariable("v_zeroGUpDown", true);
	pConsole->UnregisterVariable("v_zeroGMaxSpeed", true);
	pConsole->UnregisterVariable("v_zeroGSpeedMaxSpeed", true);
	pConsole->UnregisterVariable("v_zeroGSpeedModeEnergyConsumption", true);
	pConsole->UnregisterVariable("v_zeroGSwitchableGyro", true);
	pConsole->UnregisterVariable("v_zeroGEnableGBoots", true);
	pConsole->UnregisterVariable("v_dumpFriction", true);
  pConsole->UnregisterVariable("v_debugSounds", true);
	pConsole->UnregisterVariable("v_altitudeLimit", true);
	pConsole->UnregisterVariable("v_altitudeLimitLowerOffset", true);
	pConsole->UnregisterVariable("v_airControlSensivity", true);

	// variables from CPlayer
	pConsole->UnregisterVariable("player_DrawIK", true);
	pConsole->UnregisterVariable("player_NoIK", true);
	pConsole->UnregisterVariable("g_enableIdleCheck", true);
	pConsole->UnregisterVariable("pl_debug_ladders", true);
	pConsole->UnregisterVariable("pl_debug_movement", true);
	pConsole->UnregisterVariable("pl_debug_filter", true);

	// alien debugging
	pConsole->UnregisterVariable("aln_debug_movement", true);
	pConsole->UnregisterVariable("aln_debug_filter", true);

	// variables from CPlayerMovementController
	pConsole->UnregisterVariable("g_showIdleStats", true);
	pConsole->UnregisterVariable("g_debugaimlook", true);

	// variables from CHUD
	pConsole->UnregisterVariable("hud_mpNamesNearDistance", true);
	pConsole->UnregisterVariable("hud_mpNamesFarDistance", true);
	pConsole->UnregisterVariable("hud_onScreenNearDistance", true);
	pConsole->UnregisterVariable("hud_onScreenFarDistance", true);
	pConsole->UnregisterVariable("hud_onScreenNearSize", true);
	pConsole->UnregisterVariable("hud_onScreenFarSize", true);
	pConsole->UnregisterVariable("hud_colorLine", true);
	pConsole->UnregisterVariable("hud_colorOver", true);
	pConsole->UnregisterVariable("hud_colorText", true);
	pConsole->UnregisterVariable("hud_showAllObjectives", true);
	pConsole->UnregisterVariable("hud_godfadetime", true);
	pConsole->UnregisterVariable("g_combatfadetime", true);
	pConsole->UnregisterVariable("g_combatfadetimedelay", true);
	pConsole->UnregisterVariable("g_battlerange", true);
	pConsole->UnregisterVariable("hud_centernames", true);
	pConsole->UnregisterVariable("hud_crosshair", true);
	pConsole->UnregisterVariable("hud_chdamageindicator", true);
	pConsole->UnregisterVariable("hud_panoramic", true);
	pConsole->UnregisterVariable("hud_voicemode", true);
	pConsole->UnregisterVariable("hud_enableAlienInterference", true);
	pConsole->UnregisterVariable("hud_alienInterferenceStrength", true);
	pConsole->UnregisterVariable("hud_crosshair_enable", true);
	pConsole->UnregisterVariable("hud_attachBoughEquipment", true);
	pConsole->UnregisterVariable("hud_subtitlesRenderMode", true);
	pConsole->UnregisterVariable("hud_panoramicHeight", true);
	pConsole->UnregisterVariable("hud_subtitles", true);
	pConsole->UnregisterVariable("hud_subtitlesFontSize", true);
	pConsole->UnregisterVariable("hud_subtitlesHeight", true);
	pConsole->UnregisterVariable("hud_startPaused", true);
	pConsole->UnregisterVariable("hud_nightVisionRecharge", true);
	pConsole->UnregisterVariable("hud_nightVisionConsumption", true);
	pConsole->UnregisterVariable("hud_showBigVehicleReload", true);
	pConsole->UnregisterVariable("hud_binocsScanningDelay", true);
	pConsole->UnregisterVariable("hud_binocsScanningWidth", true);
	
	// variables from CHUDRadar
	pConsole->UnregisterVariable("hud_radarBackground", true);
	pConsole->UnregisterVariable("hud_radarJammingThreshold", true);
	pConsole->UnregisterVariable("hud_radarJammingEffectScale", true);

	// Controller aim helper cvars
	pConsole->UnregisterVariable("aim_assistSearchBox", true);
	pConsole->UnregisterVariable("aim_assistMaxDistance", true);
	pConsole->UnregisterVariable("aim_assistSnapDistance", true);
	pConsole->UnregisterVariable("aim_assistVerticalScale", true);
	pConsole->UnregisterVariable("aim_assistSingleCoeff", true);
	pConsole->UnregisterVariable("aim_assistAutoCoeff", true);
	pConsole->UnregisterVariable("aim_assistRestrictionTimeout", true);

	pConsole->UnregisterVariable("hud_aspectCorrection", true);
	pConsole->UnregisterVariable("hud_ctrl_Curve_X", true);
	pConsole->UnregisterVariable("hud_ctrl_Curve_Z", true);
	pConsole->UnregisterVariable("hud_ctrl_Coeff_X", true);
	pConsole->UnregisterVariable("hud_ctrl_Coeff_Z", true);
	pConsole->UnregisterVariable("hud_ctrlZoomMode", true);

	// Aim assitance switches
	pConsole->UnregisterVariable("aim_assistAimEnabled", true);
	pConsole->UnregisterVariable("aim_assistTriggerEnabled", true);
	pConsole->UnregisterVariable("hit_assistSingleplayerEnabled", true);
	pConsole->UnregisterVariable("hit_assistMultiplayerEnabled", true);
		
	// weapon system
	pConsole->UnregisterVariable("i_debuggun_1", true);
	pConsole->UnregisterVariable("i_debuggun_2", true);

	pConsole->UnregisterVariable("tracer_min_distance", true);
	pConsole->UnregisterVariable("tracer_max_distance", true);
	pConsole->UnregisterVariable("tracer_min_scale", true);
	pConsole->UnregisterVariable("tracer_max_scale", true);
	pConsole->UnregisterVariable("tracer_max_count", true);
	pConsole->UnregisterVariable("tracer_player_radiusSqr", true);

	pConsole->UnregisterVariable("i_debug_projectiles", true);
	pConsole->UnregisterVariable("i_auto_turret_target", true);
	pConsole->UnregisterVariable("i_auto_turret_target_tacshells", true);

  pConsole->UnregisterVariable("i_debug_zoom_mods", true);
	pConsole->UnregisterVariable("i_debug_mp_flowgraph", true);

  pConsole->UnregisterVariable("g_quickGame_map",true);
  pConsole->UnregisterVariable("g_quickGame_mode",true);
  pConsole->UnregisterVariable("g_quickGame_min_players",true);
  pConsole->UnregisterVariable("g_quickGame_prefer_lan",true);
  pConsole->UnregisterVariable("g_quickGame_prefer_favorites",true);
  pConsole->UnregisterVariable("g_quickGame_prefer_mycountry",true);
  pConsole->UnregisterVariable("g_quickGame_ping1_level",true);
  pConsole->UnregisterVariable("g_quickGame_ping2_level",true);
	pConsole->UnregisterVariable("g_quickGame_debug",true);
	pConsole->UnregisterVariable("g_skip_tutorial",true);

	pConsole->UnregisterVariable("g_displayIgnoreList",true);
  pConsole->UnregisterVariable("g_buddyMessagesIngame",true);

  pConsole->UnregisterVariable("g_battleDust_enable", true);
  pConsole->UnregisterVariable("g_battleDust_debug", true);
	pConsole->UnregisterVariable("g_battleDust_effect", true);

  pConsole->UnregisterVariable("g_PSTutorial_Enabled", true);

  pConsole->UnregisterVariable("g_proneNotUsableWeapon_FixType", true);
	pConsole->UnregisterVariable("g_proneAimAngleRestrict_Enable", true);

  pConsole->UnregisterVariable("sv_voting_timeout",true);
  pConsole->UnregisterVariable("sv_voting_cooldown",true);
  pConsole->UnregisterVariable("sv_voting_ratio",true);
  pConsole->UnregisterVariable("sv_voting_team_ratio",true);

	pConsole->UnregisterVariable("g_spectate_TeamOnly", true);
	pConsole->UnregisterVariable("g_claymore_limit", true);
	pConsole->UnregisterVariable("g_avmine_limit", true);
	pConsole->UnregisterVariable("g_debugMines", true);

 pConsole->UnregisterVariable("aim_assistCrosshairSize", true);
  pConsole->UnregisterVariable("aim_assistCrosshairDebug", true);

	pConsole->UnregisterVariable("g_ColorGradingBlendTime", true);
}

//------------------------------------------------------------------------
void CGame::CmdDumpSS(IConsoleCmdArgs *pArgs)
{
	g_pGame->GetSynchedStorage()->Dump();
}

//------------------------------------------------------------------------
void CGame::RegisterConsoleVars()
{
	assert(m_pConsole);

	if (m_pCVars)
	{
		m_pCVars->InitCVars(m_pConsole);    
	}
}

//------------------------------------------------------------------------
void CmdDumpItemNameTable(IConsoleCmdArgs *pArgs)
{
	SharedString::CSharedString::DumpNameTable();
}


//------------------------------------------------------------------------
void CmdGoto(IConsoleCmdArgs *pArgs)
{
	// feature is mostly useful for QA purposes, the editor has a similar feature, here we can call the editor command as well

	// todo:
	// * move to CryAction
	// * if in editor and game is not active it should move editor camera
	// * third person game should work by using player position
	// * level name could be part of the string

	const CCamera &rCam = gEnv->pRenderer->GetCamera();
	Matrix33 m = Matrix33(rCam.GetMatrix());

	int iArgCount = pArgs->GetArgCount();

	Ang3 aAngDeg = RAD2DEG(Ang3::GetAnglesXYZ(m));		// in degrees
	Vec3 vPos = rCam.GetPosition();

	if(iArgCount==1)
	{
		gEnv->pLog->Log("$5GOTO %d %d %d %d %d %d",(int)vPos.x,(int)vPos.y,(int)vPos.z, (int)aAngDeg.x,(int)aAngDeg.y,(int)aAngDeg.z);
		return;
	}

	// complicated but maybe the best Entity we can move to the given spot
	IGame *pGame = gEnv->pGame;																								if(!pGame)return;
	IGameFramework *pGameFramework=pGame->GetIGameFramework();								if(!pGameFramework)return;
	IViewSystem *pViewSystem=pGameFramework->GetIViewSystem();								if(!pViewSystem)return;
	IView *pView=pViewSystem->GetActiveView();																if(!pView)return;
	IEntity *pEntity = gEnv->pEntitySystem->GetEntity(pView->GetLinkedId());	if(!pEntity)return;

	if((iArgCount==4 || iArgCount==7)
		&& sscanf(pArgs->GetArg(1),"%f",&vPos.x)==1
		&& sscanf(pArgs->GetArg(2),"%f",&vPos.y)==1
		&& sscanf(pArgs->GetArg(3),"%f",&vPos.z)==1)
	{
		Matrix34 tm = pEntity->GetWorldTM();

		tm.SetTranslation(vPos);

		if(iArgCount==7
			&& sscanf(pArgs->GetArg(4),"%f",&aAngDeg.x)==1
			&& sscanf(pArgs->GetArg(5),"%f",&aAngDeg.y)==1
			&& sscanf(pArgs->GetArg(6),"%f",&aAngDeg.z)==1)
		{
			tm.SetRotation33( Matrix33::CreateRotationXYZ(DEG2RAD(aAngDeg)) );
		}

		// if there is an editor
		char str[256];
		sprintf(str,"ED_GOTO %.f %.f %.f %.f %.f %.f",vPos.x,vPos.y,vPos.z,aAngDeg.x,aAngDeg.y,aAngDeg.z);
		gEnv->pConsole->ExecuteString(str,true);

		pEntity->SetWorldTM(tm);
		return;
	}

	gEnv->pLog->LogError("GOTO: Invalid arguments");
}


//------------------------------------------------------------------------
void CGame::RegisterConsoleCommands()
{
	assert(m_pConsole);

	REGISTER_COMMAND("quit", "System.Quit()", VF_RESTRICTEDMODE, "Quits the game");
	REGISTER_COMMAND("goto", CmdGoto, VF_CHEAT, 
		"Get or set the current position and orientation for the player\n"
		"Usage: goto\n"
		"Usage: goto x y z\n"
		"Usage: goto x y z wx wy wz\n");
	REGISTER_COMMAND("gotoe", "local e=System.GetEntityByName(%1); if (e) then g_localActor:SetWorldPos(e:GetWorldPos()); end", VF_CHEAT, "Set the position of a entity with an given name");
	REGISTER_COMMAND("freeze", "g_gameRules:SetFrozenAmount(g_localActor,1)", 0, "Freezes player");

	REGISTER_COMMAND("loadactionmap", CmdLoadActionmap, 0, "Loads a key configuration file");
	REGISTER_COMMAND("restartgame", CmdRestartGame, 0, "Restarts Crysis completely.");
	REGISTER_COMMAND("i_dump_ammo_pool_stats", CmdDumpAmmoPoolStats, 0, "Dumps statistics related to the weapon ammo pool.");

	REGISTER_COMMAND("lastinv", CmdLastInv, 0, "Selects last inventory item used.");
	REGISTER_COMMAND("name", CmdName, VF_RESTRICTEDMODE, "Sets player name.");
	REGISTER_COMMAND("team", CmdTeam, VF_RESTRICTEDMODE, "Sets player team.");
	REGISTER_COMMAND("loadLastSave", CmdLoadLastSave, 0, "Loads the last savegame if available.");
	REGISTER_COMMAND("spectator", CmdSpectator, 0, "Sets the player as a spectator.");
	REGISTER_COMMAND("join_game", CmdJoinGame, VF_RESTRICTEDMODE, "Enter the current ongoing game.");
	REGISTER_COMMAND("kill", CmdKill, VF_RESTRICTEDMODE, "Kills the player.");
  REGISTER_COMMAND("v_kill", CmdVehicleKill, VF_CHEAT, "Kills the players vehicle.");
	REGISTER_COMMAND("sv_restart", CmdRestart, 0, "Restarts the round.");
	REGISTER_COMMAND("sv_say", CmdSay, 0, "Broadcasts a message to all clients.");
	REGISTER_COMMAND("i_reload", CmdReloadItems, 0, "Reloads item scripts.");

	REGISTER_COMMAND("dumpss", CmdDumpSS, 0, "test synched storage.");
	REGISTER_COMMAND("dumpnt", CmdDumpItemNameTable, 0, "Dump ItemString table.");

  REGISTER_COMMAND("g_reloadGameRules", CmdReloadGameRules, 0, "Reload GameRules script");
  REGISTER_COMMAND("g_quickGame", CmdQuickGame, 0, "Quick connect to good server.");
  REGISTER_COMMAND("g_quickGameStop", CmdQuickGameStop, 0, "Cancel quick game search.");

  REGISTER_COMMAND("g_nextlevel", CmdNextLevel,0,"Switch to next level in rotation or restart current one.");
  REGISTER_COMMAND("vote", CmdVote, VF_RESTRICTEDMODE, "Vote on current topic.");
  REGISTER_COMMAND("startKickVoting",CmdStartKickVoting, VF_RESTRICTEDMODE, "Initiate voting.");
  REGISTER_COMMAND("startNextMapVoting",CmdStartNextMapVoting, VF_RESTRICTEDMODE, "Initiate voting.");

	REGISTER_COMMAND("g_battleDust_reload", CmdBattleDustReload, 0, "Reload the battle dust parameters xml");
  REGISTER_COMMAND("login",CmdLogin,0,"Log in as to CryNetwork using nickname and password as arguments");
	REGISTER_COMMAND("login_profile",CmdLoginProfile,0,"Log in as to CryNetwork using email, profile and password as arguments");
	REGISTER_COMMAND("connect_crynet",CmdCryNetConnect,0,"Connect to online game server");
	REGISTER_COMMAND("test_pathfinder",CmdTestPathfinder,VF_CHEAT,"");
	REGISTER_COMMAND("preloadforstats","PreloadForStats()",VF_CHEAT,"Preload multiplayer assets for memory statistics.");
}

//------------------------------------------------------------------------
void CGame::UnregisterConsoleCommands()
{
	assert(m_pConsole);

	m_pConsole->RemoveCommand("quit");
	m_pConsole->RemoveCommand("goto");
	m_pConsole->RemoveCommand("freeze");

	m_pConsole->RemoveCommand("loadactionmap");
	m_pConsole->RemoveCommand("restartgame");

	m_pConsole->RemoveCommand("name");
	m_pConsole->RemoveCommand("team");
	m_pConsole->RemoveCommand("kill");
  m_pConsole->RemoveCommand("v_kill");
	m_pConsole->RemoveCommand("sv_restart");
	m_pConsole->RemoveCommand("sv_say");
	m_pConsole->RemoveCommand("i_reload");

	m_pConsole->RemoveCommand("dumpss");

	m_pConsole->RemoveCommand("g_reloadGameRules");
  m_pConsole->RemoveCommand("g_quickGame");
  m_pConsole->RemoveCommand("g_quickGameStop");

  m_pConsole->RemoveCommand("g_nextlevel");
  m_pConsole->RemoveCommand("g_vote");
  m_pConsole->RemoveCommand("g_startKickVoting");
  m_pConsole->RemoveCommand("g_startNextMapVoting");


	m_pConsole->RemoveCommand("g_battleDust_reload");
	m_pConsole->RemoveCommand("bulletTimeMode");
	m_pConsole->RemoveCommand("GOCMode");

	// variables from CHUDCommon
	m_pConsole->RemoveCommand("ShowGODMode");

	m_pConsole->RemoveCommand("test_pathfinder");
}

//------------------------------------------------------------------------
void CGame::CmdLastInv(IConsoleCmdArgs *pArgs)
{
	if (!gEnv->bClient)
		return;

	if (CActor *pClientActor=static_cast<CActor *>(g_pGame->GetIGameFramework()->GetClientActor()))
		pClientActor->SelectLastItem(true);
}

//------------------------------------------------------------------------
void CGame::CmdName(IConsoleCmdArgs *pArgs)
{
	if (!gEnv->bClient)
		return;

	IActor *pClientActor=g_pGame->GetIGameFramework()->GetClientActor();
	if (!pClientActor)
		return;

	CGameRules *pGameRules = g_pGame->GetGameRules();
	if (pGameRules)
		pGameRules->RenamePlayer(pGameRules->GetActorByEntityId(pClientActor->GetEntityId()), pArgs->GetArg(1));
}

//------------------------------------------------------------------------
void CGame::CmdTeam(IConsoleCmdArgs *pArgs)
{
	if (!gEnv->bClient)
		return;

	IActor *pClientActor=g_pGame->GetIGameFramework()->GetClientActor();
	if (!pClientActor)
		return;

	CGameRules *pGameRules = g_pGame->GetGameRules();
	if (pGameRules)
		pGameRules->ChangeTeam(pGameRules->GetActorByEntityId(pClientActor->GetEntityId()), pArgs->GetArg(1));
}

//------------------------------------------------------------------------
void CGame::CmdLoadLastSave(IConsoleCmdArgs *pArgs)
{
	if (!gEnv->bClient || gEnv->bMultiplayer)
		return;

	const string& file = g_pGame->GetLastSaveGame();
	if(file.length())
	{
		if(!g_pGame->GetIGameFramework()->LoadGame(file.c_str(), true))
			g_pGame->GetIGameFramework()->LoadGame(file.c_str(), false);
	}
}

//------------------------------------------------------------------------
void CGame::CmdSpectator(IConsoleCmdArgs *pArgs)
{
	if (!gEnv->bClient)
		return;

	IActor *pClientActor=g_pGame->GetIGameFramework()->GetClientActor();
	if (!pClientActor)
		return;

	CGameRules *pGameRules = g_pGame->GetGameRules();
	if (pGameRules)
	{
		int mode=2;
		if (pArgs->GetArgCount()==2)
			mode=atoi(pArgs->GetArg(1));
		pGameRules->ChangeSpectatorMode(pGameRules->GetActorByEntityId(pClientActor->GetEntityId()), mode, 0, true);
	}
}

//------------------------------------------------------------------------
void CGame::CmdJoinGame(IConsoleCmdArgs *pArgs)
{
	if (!gEnv->bClient)
		return;

	IActor *pClientActor=g_pGame->GetIGameFramework()->GetClientActor();
	if (!pClientActor)
		return;

	if (g_pGame->GetGameRules()->GetTeamCount()>0)
		return;
	
	CGameRules *pGameRules = g_pGame->GetGameRules();
	if (pGameRules)
		pGameRules->ChangeSpectatorMode(pGameRules->GetActorByEntityId(pClientActor->GetEntityId()), 0, 0, true);
}

//------------------------------------------------------------------------
void CGame::CmdKill(IConsoleCmdArgs *pArgs)
{
	if (!gEnv->bClient)
		return;

	IActor *pClientActor=g_pGame->GetIGameFramework()->GetClientActor();
	if (!pClientActor)
		return;

	CGameRules *pGameRules = g_pGame->GetGameRules();
	if (pGameRules)
	{
		HitInfo suicideInfo(pClientActor->GetEntityId(), pClientActor->GetEntityId(), pClientActor->GetEntityId(),
			1000, 0, 0, -1, 0, ZERO, ZERO, ZERO);
		pGameRules->ClientHit(suicideInfo);
	}
}

//------------------------------------------------------------------------
void CGame::CmdVehicleKill(IConsoleCmdArgs *pArgs)
{
  if (!gEnv->bClient)
    return;

  IActor *pClientActor=g_pGame->GetIGameFramework()->GetClientActor();
  if (!pClientActor)
    return;

  IVehicle* pVehicle = pClientActor->GetLinkedVehicle();
  if (!pVehicle)
    return;
  
  CGameRules *pGameRules = g_pGame->GetGameRules();
  if (pGameRules)
  {
    HitInfo suicideInfo(pVehicle->GetEntityId(), pVehicle->GetEntityId(), pVehicle->GetEntityId(),
      10000, 0, 0, -1, 0, pVehicle->GetEntity()->GetWorldPos(), ZERO, ZERO);
    pGameRules->ClientHit(suicideInfo);
  }
}

//------------------------------------------------------------------------
void CGame::CmdRestart(IConsoleCmdArgs *pArgs)
{
	if(g_pGame && g_pGame->GetGameRules())
		g_pGame->GetGameRules()->Restart();
}

//------------------------------------------------------------------------
void CGame::CmdSay(IConsoleCmdArgs *pArgs)
{
	if (pArgs->GetArgCount()>1 && gEnv->bServer)
	{
		const char *msg=pArgs->GetCommandLine()+strlen(pArgs->GetArg(0))+1;
		g_pGame->GetGameRules()->SendTextMessage(eTextMessageServer, msg, eRMI_ToAllClients);

		if (!gEnv->bClient)
			CryLogAlways("** Server: %s **", msg);
	}
}

//------------------------------------------------------------------------
void CGame::CmdLoadActionmap(IConsoleCmdArgs *pArgs)
{
	if(pArgs->GetArg(1))
		g_pGame->LoadActionMaps(pArgs->GetArg(1));
}

//------------------------------------------------------------------------
void CGame::CmdRestartGame(IConsoleCmdArgs *pArgs)
{
	GetISystem()->Relaunch(true);
	GetISystem()->Quit();
}

//------------------------------------------------------------------------
void CGame::CmdDumpAmmoPoolStats(IConsoleCmdArgs *pArgs)
{
}

//------------------------------------------------------------------------
void CGame::CmdReloadItems(IConsoleCmdArgs *pArgs)
{
	g_pGame->GetItemSharedParamsList()->Reset();
	g_pGame->GetIGameFramework()->GetIItemSystem()->Reload();
}

//------------------------------------------------------------------------
void CGame::CmdReloadGameRules(IConsoleCmdArgs *pArgs)
{
  if (gEnv->bMultiplayer)
    return;

  IGameRulesSystem* pGameRulesSystem = g_pGame->GetIGameFramework()->GetIGameRulesSystem();
  IGameRules* pGameRules = pGameRulesSystem->GetCurrentGameRules();
    
  const char* name = "SinglePlayer";
  IEntityClass* pEntityClass = 0; 
  
  if (pGameRules)    
  {
    pEntityClass = pGameRules->GetEntity()->GetClass();
    name = pEntityClass->GetName();
  }  
  else
    pEntityClass = gEnv->pEntitySystem->GetClassRegistry()->FindClass(name);

  if (pEntityClass)
  {
    pEntityClass->LoadScript(true);
  
    if (pGameRulesSystem->CreateGameRules(name))
      CryLog("reloaded GameRules <%s>", name);
    else
      GameWarning("reloading GameRules <%s> failed!", name);
  }  
}

void CGame::CmdNextLevel(IConsoleCmdArgs* pArgs)
{
  ILevelRotation *pLevelRotation = g_pGame->GetIGameFramework()->GetILevelSystem()->GetLevelRotation();
  if (pLevelRotation->GetLength())
    pLevelRotation->ChangeLevel(pArgs);
}

void CGame::CmdStartKickVoting(IConsoleCmdArgs* pArgs)
{
  if (!gEnv->bClient)
    return;

  if (pArgs->GetArgCount() < 2)
  {
    GameWarning("usage: g_startKickVoting player_name");
    return;
  }

  IActor *pClientActor=g_pGame->GetIGameFramework()->GetClientActor();
  if (!pClientActor)
    return;

  IEntity* pEntity = gEnv->pEntitySystem->FindEntityByName(pArgs->GetArg(1));
  if(pEntity)
  {
    IActor* pActor = g_pGame->GetIGameFramework()->GetIActorSystem()->GetActor(pEntity->GetId());
    if(pActor && pActor->IsPlayer())
    {
      CGameRules *pGameRules = g_pGame->GetGameRules();
      if (pGameRules)
      {
        pGameRules->StartVoting(pGameRules->GetActorByEntityId(pClientActor->GetEntityId()),eVS_kick,pEntity->GetId(),"");
      }
    }
  }
}

void CGame::CmdStartNextMapVoting(IConsoleCmdArgs* pArgs)
{
  if (!gEnv->bClient)
    return;

  IActor *pClientActor=g_pGame->GetIGameFramework()->GetClientActor();
  if (!pClientActor)
    return;

  CGameRules *pGameRules = g_pGame->GetGameRules();
  if (pGameRules)
  {
    pGameRules->StartVoting(pGameRules->GetActorByEntityId(pClientActor->GetEntityId()),eVS_nextMap,0,"");
  }
}


void CGame::CmdVote(IConsoleCmdArgs* pArgs)
{
  if (!gEnv->bClient)
    return;

  IActor *pClientActor=g_pGame->GetIGameFramework()->GetClientActor();
  if (!pClientActor)
    return;

  CGameRules *pGameRules = g_pGame->GetGameRules();
  if (pGameRules)
  {
    pGameRules->Vote(pGameRules->GetActorByEntityId(pClientActor->GetEntityId()), true);
  }
}

void CGame::CmdQuickGame(IConsoleCmdArgs* pArgs)
{
}

void CGame::CmdQuickGameStop(IConsoleCmdArgs* pArgs)
{
  
}

void CGame::CmdBattleDustReload(IConsoleCmdArgs* pArgs)
{
	if(CBattleDust* pBD = g_pGame->GetGameRules()->GetBattleDust())
	{
		pBD->ReloadXml();
	}
}

static bool GSCheckComplete()
{
  INetworkService* serv = gEnv->pNetwork->GetService("GameSpy");
  if(!serv)
    return true;
  return serv->GetState() != eNSS_Initializing;
}

static bool GSLoggingIn()
{
  //return !g_pGame->GetMenu()->GetMPHub()->IsLoggingIn();
	return false;
}

void CGame::CmdLogin(IConsoleCmdArgs* pArgs)
{
  if(pArgs->GetArgCount()>2)
  {
    g_pGame->BlockingProcess(&GSCheckComplete);
    INetworkService* serv = gEnv->pNetwork->GetService("GameSpy");
    if(!serv || serv->GetState() != eNSS_Ok)
      return;
		if(gEnv->pSystem->IsDedicated())
		{
			if(INetworkProfile* profile = serv->GetNetworkProfile())
			{
				profile->Login(pArgs->GetArg(1),pArgs->GetArg(2));
			}			
		}
  }
  else
    GameWarning("Invalid parameters.");
}

void CGame::CmdLoginProfile(IConsoleCmdArgs* pArgs)
{
	if(pArgs->GetArgCount()>3)
	{
// 		g_pGame->BlockingProcess(&GSCheckComplete);
// 		INetworkService* serv = gEnv->pNetwork->GetService("GameSpy");
// 		if(!serv || serv->GetState() != eNSS_Ok)
// 			return;
// 		g_pGame->GetMenu()->GetMPHub()->DoLoginProfile(pArgs->GetArg(1),pArgs->GetArg(2),pArgs->GetArg(3));
// 
// 		g_pGame->BlockingProcess(&GSLoggingIn);
	}
	else
		GameWarning("Invalid parameters.");
}

static bool gGSConnecting = false;

struct SCryNetConnectListener : public IServerListener
{
  virtual void RemoveServer(const int id){}
  virtual void UpdatePing(const int id,const int ping){}
  virtual void UpdateValue(const int id,const char* name,const char* value){}
  virtual void UpdatePlayerValue(const int id,const int playerNum,const char* name,const char* value){}
  virtual void UpdateTeamValue(const int id,const int teamNum,const char *name,const char* value){}
  virtual void UpdateComplete(bool cancelled){}

  //we only need this thing to connect to server
  
  virtual void OnError(const EServerBrowserError)
  {
    End(false);
  }
  
  virtual void NewServer(const int id,const SBasicServerInfo* info)
  {	
    UpdateServer(id, info);
  }

  virtual void UpdateServer(const int id,const SBasicServerInfo* info)
  {
    m_port = info->m_hostPort;
  }

  virtual void ServerUpdateFailed(const int id)
  {
    End(false);
  }
  virtual void ServerUpdateComplete(const int id)
  { 
    m_browser->CheckDirectConnect(id,m_port);
  }

  virtual void ServerDirectConnect(bool neednat, uint ip, ushort port)
  {
    string connect;
    if(neednat)
    {
      int cookie = rand() + (rand()<<16);
      connect.Format("connect <nat>%d|%d.%d.%d.%d:%d",cookie,ip&0xFF,(ip>>8)&0xFF,(ip>>16)&0xFF,(ip>>24)&0xFF,port);
      m_browser->SendNatCookie(ip,port,cookie);
    }
    else
    {
      connect.Format("connect %d.%d.%d.%d:%d",ip&0xFF,(ip>>8)&0xFF,(ip>>16)&0xFF,(ip>>24)&0xFF,port);
    }
    m_browser->Stop();
    End(true);
    g_pGame->GetIGameFramework()->ExecuteCommandNextFrame(connect.c_str());
  }

  void End(bool success)
  {
    if(!success)
      CryLog("Server is not responding.");
    gGSConnecting = false;
    m_browser->Stop();
    m_browser->SetListener(0);
    delete this;
  }

  IServerBrowser* m_browser;
  ushort m_port;
};


static bool GSConnect()
{
  return !gGSConnecting;
}

void CGame::CmdCryNetConnect(IConsoleCmdArgs* pArgs)
{
  ushort port = 64087;

  if(pArgs->GetArgCount()>2)
    port = atoi(pArgs->GetArg(2));
  else
  {
    ICVar* pv = gEnv->pConsole->GetCVar("cl_serverport");
    if(pv)
      port = pv->GetIVal();
  }
  if(pArgs->GetArgCount()>1)
  {
    g_pGame->BlockingProcess(&GSCheckComplete);
    INetworkService* serv = gEnv->pNetwork->GetService("GameSpy");
    if(!serv || serv->GetState() != eNSS_Ok)
      return;
    IServerBrowser* sb = serv->GetServerBrowser();

    SCryNetConnectListener* lst = new SCryNetConnectListener();
    lst->m_browser = sb;
    sb->SetListener(lst);
    sb->Start(false);
    sb->BrowseForServer(pArgs->GetArg(1),port);
    gGSConnecting = true;
    g_pGame->BlockingProcess(&GSConnect);
  }
  else
    GameWarning("Invalid parameters.");
}



// Small test for the IPathfinder.h interfaces
INavPath *g_testPath=0;
IPathFollower *g_pathFollower=0;
Vec3 g_pos(ZERO);
Vec3 g_vel(ZERO);

void CGame::CmdTestPathfinder(IConsoleCmdArgs *pArgs)
{
	if (pArgs->GetArgCount()<3)
	{
		GameWarning("Invalid parameters.");

		return;
	}

	IAIPathFinder *pPathFinder=gEnv->pAISystem->GetIAIPathFinder();
	assert(pPathFinder);

	class PathAgent: public IAIPathAgent
	{
	public:
		PathAgent(): lastNavNode(0) {};
		virtual IEntity *GetPathAgentEntity() const
		{
			return g_pGame->GetIGameFramework()->GetClientActor()->GetEntity();
		}

		virtual const char *GetPathAgentName() const
		{
			return g_pGame->GetIGameFramework()->GetClientActor()->GetEntity()->GetName();
		}

		virtual unsigned short GetPathAgentType() const
		{
			return AIOBJECT_DUMMY;
		}

		virtual float GetPathAgentPassRadius() const
		{
			return 0.3f;
		}

		virtual Vec3 GetPathAgentPos() const
		{
			return g_pGame->GetIGameFramework()->GetClientActor()->GetEntity()->GetWorldPos();
		}

		virtual Vec3 GetPathAgentVelocity() const
		{
			return ZERO;
		}

		virtual const AgentMovementAbility &GetPathAgentMovementAbility() const
		{
			return movementAbility;
		}

		virtual void PathEvent(SAIEVENT *pEvent)
		{
			if (!pEvent->bPathFound)
			{
				CryLogAlways("A path was not found!");
				delete this;
				return;
			}

			CryLogAlways("A path was found! Following it!");

			if (!g_testPath)
			{
				g_testPath=gEnv->pAISystem->GetIAIPathFinder()->CreateEmptyPath();
				assert(g_testPath);

				assert(g_testPath->Empty());

				g_pathFollower=gEnv->pAISystem->GetIAIPathFinder()->CreatePathFollower(
					PathFollowerParams(4.0f, 0.4f, 1.0f, 5.0f, 2.0f, 8.0f, 0.0f, true, true));
				assert(g_pathFollower);
			}

			gEnv->pAISystem->GetIAIPathFinder()->GetCurrentPath()->CopyTo(g_testPath);
			assert(!g_testPath->Empty());

			g_pathFollower->Reset();
			g_pathFollower->AttachToPath(g_testPath);

			delete this;
		}

		virtual void GetPathAgentNavigationBlockers(NavigationBlockers &blockers, const PathfindRequest *pRequest) const
		{
		}

		virtual unsigned int GetPathAgentLastNavNode() const
		{
			return lastNavNode;
		}

		virtual void SetPathAgentLastNavNode(unsigned int lastNavNode) 
		{
			this->lastNavNode=lastNavNode;
		}

		virtual Vec3 GetForcedStartPos() const { return ZERO; }

		AgentMovementAbility movementAbility;
		unsigned int lastNavNode;
	};

	PathAgent *pRequester=new PathAgent();
	pRequester->movementAbility.pathfindingProperties=AgentPathfindingProperties(
		IAISystem::NAV_TRIANGULAR | IAISystem::NAV_WAYPOINT_HUMAN | IAISystem::NAV_SMARTOBJECT, 
		0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 
		5.0f, 0.5f, -10000.0f, 0.0f, 20.0f, 7.0f);

	pRequester->movementAbility.b3DMove=false;
	pRequester->movementAbility.bUsePathfinder=true;
	pRequester->movementAbility.usePredictiveFollowing=true;
	pRequester->movementAbility.pathRadius=0.4f;
	pRequester->movementAbility.pathSpeedLookAheadPerSpeed=-1.5f;
	pRequester->movementAbility.pathFindPrediction=0.5f;

	Vec3 end;
	end.x=(float)atof(pArgs->GetArg(1));
	end.y=(float)atof(pArgs->GetArg(2));
	end.z=(float)atof(pArgs->GetArg(3));

	Vec3 start=g_pGame->GetIGameFramework()->GetClientActor()->GetEntity()->GetWorldPos();
	Vec3 endDir(0,1,0);
	
	g_pos=start;
	g_vel.zero();

	pPathFinder->RequestPathTo(start, end, endDir, pRequester, true, -1, 0.0f, 0.0f);
}
