/*************************************************************************
  Crytek Source File.
  Copyright (C), Crytek Studios, 2001-2004.
 -------------------------------------------------------------------------
  $Id$
  $DateTime$
  Description: 
  
 -------------------------------------------------------------------------
  History:
  - 8:9:2004   10:32 : Created by Mrcio Martins

*************************************************************************/
#ifndef __ACTIONFILTER_H__
#define __ACTIONFILTER_H__

#if _MSC_VER > 1000
# pragma once
#endif


#include "IActionMapManager.h"


typedef std::set<ActionId> TFilterActions;


class CActionMapManager;

class CActionFilter :
	public IActionFilter
{
public:
	CActionFilter(CActionMapManager *pActionMapManager, const char* name, EActionFilterType type=eAFT_ActionFail);
	virtual ~CActionFilter();

	// IActionFilter
	virtual void Release() { delete this; };
	virtual void Filter(const ActionId& action);
	virtual bool SerializeXML(const XmlNodeRef& root, bool bLoading);
	virtual const char* GetName() { return m_name.c_str(); }
	virtual void Enable(bool enable);
	virtual bool Enabled() { return m_enabled; };
	// ~IActionFilter

	bool ActionFiltered(const ActionId& action);

	void GetMemoryStatistics(ICrySizer * s);

private:
	bool							m_enabled;
	CActionMapManager*m_pActionMapManager;
	TFilterActions		m_filterActions;
	EActionFilterType m_type;
	string            m_name;
};


#endif //__ACTIONFILTER_H__