#include "StdAfx.h"
#include "FlowConditionNode.h"

void CFlowNode_Condition::GetConfiguration( SFlowNodeConfig &config )
{
	static const SInputPortConfig in_config[] = {
		InputPortConfig<bool>( "condition", _HELP("Setting this input to TRUE sends the value [value] to the [true] port, otherwise to [false]") ),
		InputPortConfig_AnyType( "value", _HELP("Value to direct to a true or false port") ),
		{0}
	};
	static const SOutputPortConfig out_config[] = {
		OutputPortConfig_AnyType( "true", _HELP("Activated when the condition is true (passes the value through)") ),
		OutputPortConfig_AnyType( "false", _HELP("Activated when the condition is false (passes the value through)") ),
		{0}
	};
	config.sDescription = _HELP("LEGACY! Node to route data flow based on a boolean condition. Both inputs trigger the output.\nLegacy. Use Logic:Condition instead!");
	config.pInputPorts = in_config;
	config.pOutputPorts = out_config;
	config.SetCategory(EFLN_APPROVED);
}

void CFlowNode_Condition::ProcessEvent( EFlowEvent event, SActivationInfo *pActInfo )
{
	switch (event)
	{
	case eFE_Activate:
	case eFE_Initialize:
		bool bCondition = GetPortBool(pActInfo, 0);

		if (bCondition)
			ActivateOutput( pActInfo, 0, GetPortAny(pActInfo, 1));
		else
			ActivateOutput( pActInfo, 1, GetPortAny(pActInfo, 1));
	};
};


class CFlowNode_LogicCondition : public CFlowBaseNode
{
public:
	CFlowNode_LogicCondition( SActivationInfo * ) {}

	void GetConfiguration( SFlowNodeConfig &config )
	{
		static const SInputPortConfig in_config[] = {
			InputPortConfig<bool>  ( "Condition", _HELP("If condition is FALSE input [In] will be routed to [OnFalse], otherwise to [OnTrue]") ),
			InputPortConfig_AnyType( "In",        _HELP("Value to route to [OnFalse] or [OnTrue], based on [Condition]") ),
			{0}
		};
		static const SOutputPortConfig out_config[] = {
			OutputPortConfig_AnyType( "OnFalse", _HELP("Set to input [In] if [Condition] is FALSE)") ),
			OutputPortConfig_AnyType( "OnTrue",  _HELP("Set to input [In] if [Condition] is TRUE") ),
			{0}
		};
		config.sDescription = _HELP("Node to route data flow based on a boolean condition.\nSetting input [Value] will route it either to [OnFalse] or [OnTrue].");
		config.pInputPorts = in_config;
		config.pOutputPorts = out_config;
		config.SetCategory(EFLN_APPROVED);

	}

	virtual void GetMemoryStatistics(ICrySizer * s)
	{
		s->Add(*this);
	}

	void ProcessEvent( EFlowEvent event, SActivationInfo *pActInfo )
	{
		switch (event)
		{
		case eFE_Activate:
			// only port 1 [In] triggers an output
			if (IsPortActive(pActInfo, 1) == false)
				return;

			const bool bCondition = GetPortBool(pActInfo, 0);

			if (bCondition == false)
				ActivateOutput( pActInfo, 0, GetPortAny(pActInfo, 1));
			else
				ActivateOutput( pActInfo, 1, GetPortAny(pActInfo, 1));
		};
	}
};

REGISTER_FLOW_NODE_SINGLETON( "Condition",CFlowNode_Condition)
REGISTER_FLOW_NODE_SINGLETON( "Logic:Condition",CFlowNode_LogicCondition)
