/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2006.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description: Implements a damage behavior which send an AI signal

-------------------------------------------------------------------------
History:
- 23:11:2006: Created by Mathieu Pinard

*************************************************************************/
#include "StdAfx.h"
#include "IAgent.h"
#include "IVehicleSystem.h"
#include "VehicleDamageBehaviorAISignal.h"

//------------------------------------------------------------------------
bool CVehicleDamageBehaviorAISignal::Init(IVehicle* pVehicle, const SmartScriptTable &table)
{
	m_pVehicle = pVehicle;

	SmartScriptTable signalTable;
	if (!table->GetValue("AISignal", signalTable))
		return false;

	if (!signalTable->GetValue("signalId", m_signalId))
		return false;
	
	char* pSignalText;
	if (signalTable->GetValue("signalText", pSignalText))
		m_signalText = pSignalText;

	return true;
}

//------------------------------------------------------------------------
void CVehicleDamageBehaviorAISignal::OnDamageEvent(EVehicleDamageBehaviorEvent event, 
																									 const SVehicleDamageBehaviorEventParams& behaviorParams)
{
	if (event != eVDBE_Hit)
		return;

	IEntity* pEntity = m_pVehicle->GetEntity();
	if (!pEntity || !pEntity->GetAI())
		return;

	IAISystem* pAISystem = gEnv->pAISystem;
	assert(pAISystem);

	IAISignalExtraData* pExtraData = pAISystem->CreateSignalExtraData();
	assert(pExtraData);

	if (pExtraData)
		pExtraData->iValue = behaviorParams.shooterId;

	pAISystem->SendSignal(SIGNALFILTER_SENDER, m_signalId, m_signalText.c_str(), pEntity->GetAI(), pExtraData);
}

void CVehicleDamageBehaviorAISignal::GetMemoryStatistics(ICrySizer * s)
{
	s->Add(*this);
	s->Add(m_signalText);
}

DEFINE_VEHICLEOBJECT(CVehicleDamageBehaviorAISignal);
