STRUCT_INFO_BEGIN(RandomColor)
	STRUCT_VAR_INFO(m_fVarRandom, TYPE_INFO(float) ATTR_INFO(Min,0) ATTR_INFO(Max,1))
	STRUCT_VAR_INFO(m_bRandomHue, TYPE_INFO(bool))
STRUCT_INFO_END(RandomColor)

STRUCT_INFO_T_BEGIN(TVarParam, <T>, <class T>)
	STRUCT_VAR_INFO(m_Base, TYPE_INFO(T))
	STRUCT_VAR_INFO(m_VarRandom, TYPE_INFO(TRandom) ATTR_INFO(Inline,1) ATTR_INFO(Min,0) ATTR_INFO(Max,1))
STRUCT_INFO_T_END(TVarParam, <T>, <class T>)

STRUCT_INFO_T_BEGIN(TVarEParam, <T>, <class T>)
	STRUCT_BASE_INFO(TVarParam<T>)
	STRUCT_VAR_INFO(m_VarEmitterLife, TYPE_INFO(TCurve<T>))
STRUCT_INFO_T_END(TVarEParam, <T>, <class T>)

STRUCT_INFO_T_BEGIN(TVarEPParam, <T>, <class T>)
	STRUCT_BASE_INFO(TVarEParam<T>)
	STRUCT_VAR_INFO(m_VarParticleLife, TYPE_INFO(TCurve<T>))
STRUCT_INFO_T_END(TVarEPParam, <T>, <class T>)

STRUCT_INFO_BEGIN(STextureTiling)
	STRUCT_VAR_INFO(nTilesX, TYPE_INFO(uint) ATTR_INFO(Min,1))
	STRUCT_VAR_INFO(nTilesY, TYPE_INFO(uint) ATTR_INFO(Min,1))
	STRUCT_VAR_INFO(nFirstTile, TYPE_INFO(uint) ATTR_INFO(Min,0))
	STRUCT_VAR_INFO(nVariantCount, TYPE_INFO(uint) ATTR_INFO(Min,1))
	STRUCT_VAR_INFO(nAnimFramesCount, TYPE_INFO(uint) ATTR_INFO(Min,1))
	STRUCT_VAR_INFO(fAnimFramerate, TYPE_INFO(float) ATTR_INFO(Min,0) ATTR_INFO(SoftMax,60))
	STRUCT_VAR_INFO(bAnimCycle, TYPE_INFO(bool))
STRUCT_INFO_END(STextureTiling)

ENUM_INFO_BEGIN(EParticleFacing)
	ENUM_ELEM_INFO(, ParticleFacing_Camera)
	ENUM_ELEM_INFO(, ParticleFacing_Free)
	ENUM_ELEM_INFO(, ParticleFacing_Velocity)
	ENUM_ELEM_INFO(, ParticleFacing_Horizontal)
	ENUM_ELEM_INFO(, ParticleFacing_Water)
	ENUM_ELEM_INFO(, ParticleFacing_Terrain)
ENUM_INFO_END(EParticleFacing)

ENUM_INFO_BEGIN(EParticleBlendType)
	ENUM_ELEM_INFO(, ParticleBlendType_AlphaBased)
	ENUM_ELEM_INFO(, ParticleBlendType_ColorBased)
	ENUM_ELEM_INFO(, ParticleBlendType_Additive)
	ENUM_ELEM_INFO(, ParticleBlendType_None)
ENUM_INFO_END(EParticleBlendType)

STRUCT_INFO_TYPE_BEGIN(RectF)
	STRUCT_VAR_INFO(x, TYPE_INFO(float))
	STRUCT_VAR_INFO(y, TYPE_INFO(float))
	STRUCT_VAR_INFO(w, TYPE_INFO(float))
	STRUCT_VAR_INFO(h, TYPE_INFO(float))
STRUCT_INFO_TYPE_END(RectF)

ENUM_INFO_BEGIN(EParticlePhysicsType)
	ENUM_ELEM_INFO(, ParticlePhysics_None)
	ENUM_ELEM_INFO(, ParticlePhysics_SimpleCollision)
	ENUM_ELEM_INFO(, ParticlePhysics_SimplePhysics)
	ENUM_ELEM_INFO(, ParticlePhysics_RigidBody)
ENUM_INFO_END(EParticlePhysicsType)

ENUM_INFO_BEGIN(EParticleForceType)
	ENUM_ELEM_INFO(, ParticleForce_None)
	ENUM_ELEM_INFO(, ParticleForce_Wind)
	ENUM_ELEM_INFO(, ParticleForce_Gravity)
	ENUM_ELEM_INFO(, ParticleForce_Target)
ENUM_INFO_END(EParticleForceType)

ENUM_INFO_BEGIN(ETrinary)
	ENUM_ELEM_INFO(, Trinary_Both)
	ENUM_ELEM_INFO(, Trinary_If_True)
	ENUM_ELEM_INFO(, Trinary_If_False)
ENUM_INFO_END(ETrinary)

ENUM_INFO_BEGIN(EConfigSpecBrief)
	ENUM_ELEM_INFO(, ConfigSpec_Low)
	ENUM_ELEM_INFO(, ConfigSpec_Medium)
	ENUM_ELEM_INFO(, ConfigSpec_High)
	ENUM_ELEM_INFO(, ConfigSpec_VeryHigh)
ENUM_INFO_END(EConfigSpecBrief)

STRUCT_INFO_BEGIN(ParticleParams)
	STRUCT_VAR_INFO(bEnabled, TYPE_INFO(bool))
	STRUCT_VAR_INFO(bContinuous, TYPE_INFO(bool))
	STRUCT_VAR_INFO(fCount, TYPE_INFO(TVarEParam<float>) ATTR_INFO(Min,0) ATTR_INFO(SoftMax,1000))
	STRUCT_VAR_INFO(fEmitterLifeTime, TYPE_INFO(TVarParam<float>) ATTR_INFO(Min,0))
	STRUCT_VAR_INFO(fSpawnDelay, TYPE_INFO(TVarParam<float>) ATTR_INFO(SoftMin,0) ATTR_INFO(SoftMax,10))
	STRUCT_VAR_INFO(fPulsePeriod, TYPE_INFO(TVarParam<float>) ATTR_INFO(Min,0))
	STRUCT_VAR_INFO(fParticleLifeTime, TYPE_INFO(TVarEParam<float>) ATTR_INFO(Min,0))
	STRUCT_VAR_INFO(bRemainWhileVisible, TYPE_INFO(bool))
	STRUCT_VAR_INFO(eFacing, TYPE_INFO(EParticleFacing) ATTR_INFO(Group,"Appearance"))
	STRUCT_VAR_INFO(bOrientToVelocity, TYPE_INFO(bool))
	STRUCT_VAR_INFO(eBlendType, TYPE_INFO(EParticleBlendType))
	STRUCT_VAR_INFO(sTexture, TYPE_INFO(string))
	STRUCT_VAR_INFO(TextureTiling, TYPE_INFO(STextureTiling))
	STRUCT_VAR_INFO(sMaterial, TYPE_INFO(string))
	STRUCT_VAR_INFO(sGeometry, TYPE_INFO(string))
	STRUCT_VAR_INFO(bGeometryInPieces, TYPE_INFO(bool))
	STRUCT_VAR_INFO(bSoftParticle, TYPE_INFO(bool))
	STRUCT_VAR_INFO(bOceanParticle, TYPE_INFO(bool))
	STRUCT_VAR_INFO(fAlpha, TYPE_INFO(TVarEPParam<float>) ATTR_INFO(Group,"Lighting") ATTR_INFO(Min,0) ATTR_INFO(Max,1))
	STRUCT_VAR_INFO(cColor, TYPE_INFO(TVarEPParam<ColorF>))
	STRUCT_VAR_INFO(fDiffuseLighting, TYPE_INFO(float) ATTR_INFO(Min,0) ATTR_INFO(SoftMax,1))
	STRUCT_VAR_INFO(fDiffuseBacklighting, TYPE_INFO(float) ATTR_INFO(Min,0) ATTR_INFO(Max,1))
	STRUCT_VAR_INFO(fEmissiveLighting, TYPE_INFO(float) ATTR_INFO(Min,0) ATTR_INFO(SoftMax,1))
	STRUCT_VAR_INFO(fEmissiveHDRDynamic, TYPE_INFO(float) ATTR_INFO(Min,0) ATTR_INFO(SoftMax,2))
	STRUCT_VAR_INFO(bReceiveShadows, TYPE_INFO(bool))
	STRUCT_VAR_INFO(bCastShadows, TYPE_INFO(bool))
  STRUCT_VAR_INFO(fLightSourceIntensity, TYPE_INFO(TVarEPParam<float>) ATTR_INFO(Min,0) ATTR_INFO(SoftMax,16))
  STRUCT_VAR_INFO(fLightHDRDynamic, TYPE_INFO(TVarEPParam<float>) ATTR_INFO(Min,-2) ATTR_INFO(SoftMax,2))
  STRUCT_VAR_INFO(fLightSourceRadius, TYPE_INFO(TVarEPParam<float>) ATTR_INFO(Min,0) ATTR_INFO(SoftMax,1))
	STRUCT_VAR_INFO(fSize, TYPE_INFO(TVarEPParam<float>) ATTR_INFO(Group,"Size") ATTR_INFO(Min,0) ATTR_INFO(SoftMax,10))
	STRUCT_VAR_INFO(fTailLength, TYPE_INFO(TVarEPParam<float>) ATTR_INFO(Min,0) ATTR_INFO(SoftMax,10))
	STRUCT_VAR_INFO(nTailSteps, TYPE_INFO(uint) ATTR_INFO(Min,0) ATTR_INFO(SoftMax,16))
	STRUCT_VAR_INFO(fStretch, TYPE_INFO(TVarEPParam<float>) ATTR_INFO(Min,0) ATTR_INFO(SoftMax,10))
	STRUCT_VAR_INFO(fStretchOffsetRatio, TYPE_INFO(float))
	STRUCT_VAR_INFO(fMinPixels, TYPE_INFO(float) ATTR_INFO(Min,0) ATTR_INFO(SoftMax,10))
	STRUCT_VAR_INFO(bSecondGeneration, TYPE_INFO(bool) ATTR_INFO(Group,"Spawning"))
	STRUCT_VAR_INFO(bSpawnOnParentCollision, TYPE_INFO(bool))
	STRUCT_VAR_INFO(fInheritVelocity, TYPE_INFO(float) ATTR_INFO(SoftMin,0) ATTR_INFO(SoftMax,1))
	STRUCT_VAR_INFO(eAttachType, TYPE_INFO(EGeomType))
	STRUCT_VAR_INFO(eAttachForm, TYPE_INFO(EGeomForm))
	STRUCT_VAR_INFO(vPositionOffset, TYPE_INFO(Vec3))
	STRUCT_VAR_INFO(vRandomOffset, TYPE_INFO(Vec3))
	STRUCT_VAR_INFO(fPosRandomOffset, TYPE_INFO(float))
	STRUCT_VAR_INFO(fSpeed, TYPE_INFO(TVarEParam<float>) ATTR_INFO(Group,"Movement"))
	STRUCT_VAR_INFO(fAirResistance, TYPE_INFO(TVarEPParam<float>) ATTR_INFO(Min,0) ATTR_INFO(SoftMax,10))
	STRUCT_VAR_INFO(fGravityScale, TYPE_INFO(TVarEPParam<float>) ATTR_INFO(SoftMin,0) ATTR_INFO(SoftMax,1))
	STRUCT_VAR_INFO(vAcceleration, TYPE_INFO(Vec3))
	STRUCT_VAR_INFO(fTurbulence3DSpeed, TYPE_INFO(TVarEPParam<float>) ATTR_INFO(Min,0) ATTR_INFO(SoftMax,10))
	STRUCT_VAR_INFO(fTurbulenceSize, TYPE_INFO(TVarEPParam<float>) ATTR_INFO(Min,0) ATTR_INFO(SoftMax,10))
	STRUCT_VAR_INFO(fTurbulenceSpeed, TYPE_INFO(TVarEPParam<float>) ATTR_INFO(SoftMin,-360) ATTR_INFO(SoftMax,360))
	STRUCT_VAR_INFO(fFocusAngle, TYPE_INFO(TVarEParam<float>) ATTR_INFO(Group,"Angles") ATTR_INFO(Min,0) ATTR_INFO(Max,180))
	STRUCT_VAR_INFO(fFocusAzimuth, TYPE_INFO(TVarEParam<float>) ATTR_INFO(SoftMax,360))
	STRUCT_VAR_INFO(bFocusGravityDir, TYPE_INFO(bool))
	STRUCT_VAR_INFO(fEmitAngle, TYPE_INFO(TVarEParam<float>) ATTR_INFO(Min,0) ATTR_INFO(Max,180))
	STRUCT_VAR_INFO(vInitAngles, TYPE_INFO(Vec3) ATTR_INFO(SoftMin,-180) ATTR_INFO(SoftMax,180))
	STRUCT_VAR_INFO(vRandomAngles, TYPE_INFO(Vec3) ATTR_INFO(Min,0) ATTR_INFO(Max,180))
	STRUCT_VAR_INFO(vRotationRate, TYPE_INFO(Vec3) ATTR_INFO(SoftMin,-360) ATTR_INFO(SoftMax,360))
	STRUCT_VAR_INFO(vRandomRotationRate, TYPE_INFO(Vec3) ATTR_INFO(Min,0) ATTR_INFO(SoftMax,360))
	STRUCT_VAR_INFO(ePhysicsType, TYPE_INFO(EParticlePhysicsType) ATTR_INFO(Group,"Physics"))
	STRUCT_VAR_INFO(bCollideTerrain, TYPE_INFO(bool))
	STRUCT_VAR_INFO(bCollideStaticObjects, TYPE_INFO(bool))
	STRUCT_VAR_INFO(bCollideDynamicObjects, TYPE_INFO(bool))
	STRUCT_VAR_INFO(sSurfaceType, TYPE_INFO(string) ATTR_INFO(Select,"Surface"))
	STRUCT_VAR_INFO(fBounciness, TYPE_INFO(float) ATTR_INFO(SoftMin,0) ATTR_INFO(SoftMax,1))
	STRUCT_VAR_INFO(fDynamicFriction, TYPE_INFO(float) ATTR_INFO(Min,0) ATTR_INFO(SoftMax,10))
	STRUCT_VAR_INFO(fThickness, TYPE_INFO(float) ATTR_INFO(Min,0) ATTR_INFO(SoftMax,1))
	STRUCT_VAR_INFO(fDensity, TYPE_INFO(float) ATTR_INFO(Min,0) ATTR_INFO(SoftMax,2000))
	STRUCT_VAR_INFO(nMaxCollisionEvents, TYPE_INFO(uint) ATTR_INFO(Min,0) ATTR_INFO(SoftMax,10))
	STRUCT_VAR_INFO(eForceGeneration, TYPE_INFO(EParticleForceType))
	STRUCT_VAR_INFO(sSound, TYPE_INFO(string) ATTR_INFO(Group,"Sound"))
	STRUCT_VAR_INFO(fSoundFXParam, TYPE_INFO(TVarEParam<float>) ATTR_INFO(Min,0) ATTR_INFO(Max,1))
	STRUCT_VAR_INFO(nDrawLast, TYPE_INFO(int) ATTR_INFO(Group,"Advanced"))
	STRUCT_VAR_INFO(bSortOldestFirst, TYPE_INFO(bool))
	STRUCT_VAR_INFO(tVisibleIndoors, TYPE_INFO(ETrinary))
	STRUCT_VAR_INFO(tVisibleUnderwater, TYPE_INFO(ETrinary))
	STRUCT_VAR_INFO(bDisableVisClipping, TYPE_INFO(bool))
	STRUCT_VAR_INFO(bNotAffectedByFog, TYPE_INFO(bool))
	STRUCT_VAR_INFO(bIgnoreAttractor, TYPE_INFO(bool))
	STRUCT_VAR_INFO(bDrawNear, TYPE_INFO(bool))
	STRUCT_VAR_INFO(bNoOffset, TYPE_INFO(bool))
	STRUCT_VAR_INFO(fViewDistanceAdjust, TYPE_INFO(float) ATTR_INFO(Min,0) ATTR_INFO(SoftMax,1))
	STRUCT_VAR_INFO(fFillRateCost, TYPE_INFO(float) ATTR_INFO(Min,0) ATTR_INFO(SoftMax,10))
	STRUCT_VAR_INFO(fMotionBlurScale, TYPE_INFO(float) ATTR_INFO(Min,0) ATTR_INFO(SoftMax,2))
	STRUCT_VAR_INFO(bBindEmitterToCamera, TYPE_INFO(bool))
	STRUCT_VAR_INFO(fCameraMaxDistance, TYPE_INFO(float) ATTR_INFO(Min,0) ATTR_INFO(SoftMax,100))
	STRUCT_VAR_INFO(fCameraMinDistance, TYPE_INFO(float) ATTR_INFO(Min,0) ATTR_INFO(SoftMax,100))
	STRUCT_VAR_INFO(bBindToEmitter, TYPE_INFO(bool))
	STRUCT_VAR_INFO(bMoveRelEmitter, TYPE_INFO(bool))
	STRUCT_VAR_INFO(bSpaceLoop, TYPE_INFO(bool))
	STRUCT_VAR_INFO(bEncodeVelocity, TYPE_INFO(bool))
	STRUCT_VAR_INFO(eConfigMin, TYPE_INFO(EConfigSpecBrief) ATTR_INFO(Group,"Configuration"))
	STRUCT_VAR_INFO(eConfigMax, TYPE_INFO(EConfigSpecBrief))
	STRUCT_VAR_INFO(tDX10, TYPE_INFO(ETrinary))
	STRUCT_VAR_INFO(tGPUComputation, TYPE_INFO(ETrinary))
	STRUCT_VAR_INFO(tMultiThread, TYPE_INFO(ETrinary))
STRUCT_INFO_END(ParticleParams)

