////////////////////////////////////////////////////////////////////////////
//
//  Crytek Engine Source File.
//  Copyright (C), Crytek Studios, 2002.
// -------------------------------------------------------------------------
//  File name:   BoidsProxy.cpp
//  Version:     v1.00
//  Created:     2/10/2004 by Timur.
//  Compilers:   Visual Studio.NET
//  Description: 
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "BoidsProxy.h"
#include "Flock.h"
#include "../Entity.h"
#include "ISerialize.h"
#include "TriggerProxy.h"

//////////////////////////////////////////////////////////////////////////
CBoidsProxy::CBoidsProxy( CEntity *pEntity )
{
	m_pEntity = pEntity;
	m_pFlock = 0;
	
	// Make sure render and trigger proxy also exist.
	pEntity->CreateProxy( ENTITY_PROXY_RENDER );
	m_playersInCount = 0;
}

//////////////////////////////////////////////////////////////////////////
CBoidsProxy::~CBoidsProxy()
{
	if (m_pFlock)
		delete m_pFlock;
}

//////////////////////////////////////////////////////////////////////////
void CBoidsProxy::Release()
{
	delete this;
}

//////////////////////////////////////////////////////////////////////////
void CBoidsProxy::Update( SEntityUpdateContext &ctx )
{
	if (m_pFlock)
		m_pFlock->Update( ctx.pCamera );
}

//////////////////////////////////////////////////////////////////////////
void CBoidsProxy::ProcessEvent( SEntityEvent &event )
{
	switch (event.event) {
	case ENTITY_EVENT_XFORM:
		if (m_pFlock)
			m_pFlock->SetPos( m_pEntity->GetWorldPos() );
		break;
	case ENTITY_EVENT_PRE_SERIALIZE:
		if (m_pFlock)
			m_pFlock->DeleteEntities(true);
		break;
	case ENTITY_EVENT_ENTERAREA:
		OnTrigger(true,event);
		break;
	case ENTITY_EVENT_LEAVEAREA:
		OnTrigger(false,event);
		break;
	case ENTITY_EVENT_RESET:
		if (m_pFlock)
			m_pFlock->Reset();
		break;
	}
}

//////////////////////////////////////////////////////////////////////////
void CBoidsProxy::Serialize( TSerialize ser )
{
}

//////////////////////////////////////////////////////////////////////////
void CBoidsProxy::SetFlock( CFlock *pFlock )
{
	m_pFlock = pFlock;

	if (!pFlock)
		return;
	
	// Update trigger based on new visibility distance settings.
	float fMaxDist = pFlock->GetMaxVisibilityDistance();

	/*
	CTriggerProxy *pTrigger = (CTriggerProxy*)m_pEntity->CreateProxy( ENTITY_PROXY_TRIGGER );
	if (!pTrigger)
		return;

	AABB bbox;
	bbox.min = -Vec3(fMaxDist,fMaxDist,fMaxDist);
	bbox.max = Vec3(fMaxDist,fMaxDist,fMaxDist);
	pTrigger->SetTriggerBounds( bbox );
	*/

	IEntityAreaProxy *pArea = (IEntityAreaProxy*)m_pEntity->CreateProxy( ENTITY_PROXY_AREA );
	if (!pArea)
		return;

	pArea->SetFlags( pArea->GetFlags() & IEntityAreaProxy::FLAG_NOT_SERIALIZE );
	pArea->SetSphere( Vec3(0,0,0),fMaxDist );
	pArea->AddEntity( m_pEntity->GetId() ); // add itself.

}

//////////////////////////////////////////////////////////////////////////
void CBoidsProxy::OnTrigger( bool bEnter,SEntityEvent &event )
{
	EntityId whoId = event.nParam[0];
	IEntity *pEntity = g_pIEntitySystem->GetEntity(whoId);

	if (pEntity)
	{
		if (pEntity->GetFlags() & ENTITY_FLAG_LOCAL_PLAYER)
		{
			if (bEnter)
				m_playersInCount++;
			else
				m_playersInCount--;

			if (m_playersInCount == 1)
			{
				// Activates entity when player is nearby.
				m_pEntity->Activate(true);
				if (m_pFlock)
					m_pFlock->SetEnabled(true);
			}
			if (m_playersInCount <= 0)
			{
				// Activates entity when player is nearby.
				m_playersInCount = 0;
				m_pEntity->Activate(false);
				if (m_pFlock)
					m_pFlock->SetEnabled(false);
			}
		}
	}
}


//////////////////////////////////////////////////////////////////////////
void CBoidObjectProxy::ProcessEvent( SEntityEvent &event )
{
	if (m_pBoid)
		m_pBoid->OnEntityEvent( event );
}

//////////////////////////////////////////////////////////////////////////
void CBoidObjectProxy::Serialize( TSerialize ser )
{

}