////////////////////////////////////////////////////////////////////////////
//
//  Crytek Engine Source File.
//  Copyright (C), Crytek Studios, 2002.
// -------------------------------------------------------------------------
//  File name:   bugsflock.h
//  Version:     v1.00
//  Created:     11/4/2003 by Timur.
//  Compilers:   Visual Studio.NET
//  Description: 
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////

#ifndef __chickenboids_h__
#define __chickenboids_h__
#pragma once

#include "Flock.h"

//////////////////////////////////////////////////////////////////////////
class CChickenBoid : public CBoidBird
{
public:
	CChickenBoid( SBoidContext &bc );
	virtual void Update( float dt,SBoidContext &bc );
	virtual void Think( float dt,SBoidContext &bc );
	virtual void Kill( const Vec3 &hitPoint,const Vec3 &force );
	virtual void Physicalize( SBoidContext &bc );
	virtual void OnPickup( bool bPickup,float fSpeed );
	virtual void OnCollision( SEntityEvent &event );

protected:
	float m_maxIdleTime;
	float m_maxNonIdleTime;

	Vec3 m_avoidanceAccel;
	bool m_bThrown;
	bool m_bScared;
};

//////////////////////////////////////////////////////////////////////////
// Chicken Flock, is a specialized flock type for chickens.
//////////////////////////////////////////////////////////////////////////
class CChickenFlock : public CFlock
{
public:
	CChickenFlock( CEntity *pEntity );
	virtual void CreateBoids( SBoidsCreateContext &ctx );
	virtual CBoidObject* CreateBoid() { return new CChickenBoid(m_bc); };
	virtual void OnAIEvent(EAIEventType type, const Vec3& pos, float radius, float threat, EntityId sender);
};

//////////////////////////////////////////////////////////////////////////
class CTurtleBoid : public CChickenBoid
{
public:
	CTurtleBoid( SBoidContext &bc ) : CChickenBoid(bc) {};
	virtual void Think( float dt,SBoidContext &bc );
};

//////////////////////////////////////////////////////////////////////////
class CTurtleFlock : public CChickenFlock
{
public:
	CTurtleFlock( CEntity *pEntity );
	virtual CBoidObject* CreateBoid() { return new CTurtleBoid(m_bc); };
};

#endif // __chickenboids_h__
