////////////////////////////////////////////////////////////////////////////
//
//  Crytek Engine Source File.
//  Copyright (C), Crytek Studios, 2001-2004.
// -------------------------------------------------------------------------
//  File name:   ScriptProperties.cpp
//  Version:     v1.00
//  Created:     18/5/2004 by Timur.
//  Compilers:   Visual Studio.NET 2003
//  Description: 
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ScriptProperties.h"
#include <IScriptSystem.h>

//////////////////////////////////////////////////////////////////////////
bool CScriptProperties::SetProperties( XmlNodeRef &entityNode,IScriptTable *pEntityTable )
{
	XmlNodeRef propsNode = entityNode->findChild("Properties");
	if (propsNode)
	{
		SmartScriptTable pPropsTable;
		if (pEntityTable->GetValue( "Properties",pPropsTable ))
		{
			Assign( propsNode,pPropsTable );
		}
	}

	propsNode = entityNode->findChild("Properties2");
	if (propsNode)
	{
		SmartScriptTable pPropsTable;
		if (pEntityTable->GetValue( "PropertiesInstance",pPropsTable ))
		{
			Assign( propsNode,pPropsTable );
		}
	}

	return true;
}

//////////////////////////////////////////////////////////////////////////
void CScriptProperties::Assign( XmlNodeRef &propsNode,IScriptTable *pPropsTable )
{
	const char *key = "";
	const char *value = "";
	int nAttrs = propsNode->getNumAttributes();
	for (int attr = 0; attr < nAttrs; attr++)
	{
		if (!propsNode->getAttributeByIndex( attr,&key,&value ))
			continue;
	
		ScriptVarType varType = pPropsTable->GetValueType(key);
		switch (varType)
		{
		case svtNull:
			break;
		case svtString:
			pPropsTable->SetValue( key,value );
			break;
		case svtNumber:
		case svtBool:
			{
				float fValue = 0;
				if (stricmp(value,"true") == 0) // handle boolean.
					fValue = 1.0f;
				else
					fValue = (float)atof(value);
				pPropsTable->SetValue( key,fValue );
			}
			break;
		case svtObject:
			{
				Vec3 vec;
				propsNode->getAttr(key,vec);
				CScriptVector vecTable;
				pPropsTable->GetValue( key,vecTable );
				vecTable.Set( vec );
				//pPropsTable->SetValue( key,vec );
			}
			break;
		case svtPointer:
		case svtUserData:
		case svtFunction:
			// Ignore invalid property types.
			break;
		}
	}

	for (int i = 0; i < propsNode->getChildCount(); i++)
	{
		XmlNodeRef childNode = propsNode->getChild(i);
		SmartScriptTable pChildPropTable;
		if (pPropsTable->GetValue(childNode->getTag(),pChildPropTable))
		{
			// Recurse.
			Assign( childNode,pChildPropTable );
		}
	}
}